/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.TransformerListener;

public abstract class AbstractTransformer<C, E>
implements Transformer<C, E> {
    private List<TransformerListener> listeners = new CopyOnWriteArrayList<TransformerListener>();

    @Override
    public final void addListener(TransformerListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(TransformerListener listener) {
        this.listeners.remove(listener);
    }

    protected final void notifyListeners() {
        for (TransformerListener listener : this.listeners) {
            listener.handleSettingsChanged();
        }
    }
}

