/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.Objects;

public final class Token {
    private final Type type;
    private final int start;
    private final int end;

    public Token(Type type, int start, int end) {
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public Type getType() {
        return this.type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.end, this.start, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        Token other = (Token)obj;
        return this.end == other.end && this.start == other.start && this.type == other.type;
    }

    public String toString() {
        return "Token[" + this.type + "," + this.start + "," + this.end + "]";
    }

    public static enum Type {
        STRING_CONSTANT,
        FLOAT_CONSTANT,
        BOOLEAN_CONSTANT,
        IDENTIFIER,
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_PAREN,
        CLOSE_PAREN,
        COLON,
        CARET,
        PLUS,
        MINUS,
        DIV,
        MUL,
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        LESS_THAN,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL,
        DOLLAR,
        COMMA,
        AMPERSAND,
        EOS,
        ERROR;

    }
}

