/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.HashMap;
import java.util.List;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EquationUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    private EquationUtil() {
    }

    public static String attribNameAsReference(String attribName) {
        if (EquationUtil.isSimpleAttribName(attribName)) {
            return "$" + attribName;
        }
        return "${" + EquationUtil.escapeAttribName(attribName) + "}";
    }

    public static long doubleToLong(double d) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw new IllegalArgumentException("floating point value is too large to be converted to a Long.");
        }
        double x = Double.valueOf(d).longValue();
        if (x != d && d < 0.0) {
            x -= 1.0;
        }
        return (long)x;
    }

    private static boolean isSimpleAttribName(String attribName) {
        int length = attribName.length();
        if (length == 0) {
            throw new IllegalStateException("empty column names should never happen.");
        }
        if (!Character.isLetter(attribName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char ch = attribName.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    private static String escapeAttribName(String attribName) {
        int length = attribName.length();
        StringBuilder escapedAttribName = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char ch = attribName.charAt(i);
            switch (ch) {
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case ':': 
                case '\\': 
                case '{': 
                case '}': {
                    escapedAttribName.append('\\');
                }
            }
            escapedAttribName.append(ch);
        }
        return escapedAttribName.toString();
    }

    public static void refreshEquations(CyTable table, EquationCompiler compiler) {
        HashMap variableNameToTypeMap = new HashMap();
        for (CyColumn column : table.getColumns()) {
            variableNameToTypeMap.put(column.getName(), column.getType() == Integer.class ? Long.class : column.getType());
        }
        for (CyRow row : table.getAllRows()) {
            for (CyColumn column : table.getColumns()) {
                String name = column.getName();
                Object value = row.getRaw(name);
                if (!(value instanceof Equation)) continue;
                Equation equation = (Equation)value;
                Class<?> columnType = column.getType();
                Class<?> listElementType = column.getListElementType();
                Class expectedType = (Class)variableNameToTypeMap.remove(name);
                try {
                    if (compiler.compile(equation.toString(), variableNameToTypeMap)) {
                        Class<?> eqnType = compiler.getEquation().getType();
                        if (EquationUtil.eqnTypeIsCompatible(columnType, listElementType, eqnType)) {
                            equation = compiler.getEquation();
                        } else {
                            String errorMsg = "Equation result type is " + EquationUtil.getUnqualifiedName(eqnType) + ", column type is " + EquationUtil.getUnqualifiedName(columnType) + ".";
                            equation = compiler.getErrorEquation(equation.toString(), expectedType, errorMsg);
                        }
                        row.set(name, compiler.getEquation());
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error while restoring equation: " + equation.toString(), (Throwable)e);
                }
                variableNameToTypeMap.put(name, expectedType);
            }
        }
    }

    public static boolean eqnTypeIsCompatible(Class<?> columnType, Class<?> listElementType, Class<?> eqnType) {
        if (columnType == eqnType) {
            return true;
        }
        if (columnType == String.class) {
            return true;
        }
        if (columnType == Integer.class && (eqnType == Long.class || eqnType == Double.class)) {
            return true;
        }
        if (columnType == Long.class && (eqnType == Integer.class || eqnType == Double.class)) {
            return true;
        }
        if (columnType == Double.class && eqnType == Long.class) {
            return true;
        }
        if (columnType == Boolean.class && (eqnType == Long.class || eqnType == Double.class)) {
            return true;
        }
        if (columnType != List.class || !columnType.isAssignableFrom(eqnType)) {
            return false;
        }
        if (eqnType.getSimpleName().equals("DoubleList") && listElementType != Double.class) {
            return false;
        }
        if (eqnType.getSimpleName().equals("LongList") && listElementType != Integer.class && listElementType != Long.class) {
            return false;
        }
        if (eqnType.getSimpleName().equals("BooleanList") && listElementType != Boolean.class) {
            return false;
        }
        return !eqnType.getSimpleName().equals("StringList") || listElementType == String.class;
    }

    public static String getUnqualifiedName(Class<?> type) {
        String typeName = type.getName();
        int lastDotPos = typeName.lastIndexOf(46);
        return lastDotPos == -1 ? typeName : typeName.substring(lastDotPos + 1);
    }
}

