/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.util.Map;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;

public abstract class AbstractViewUpdater<S>
implements RowsSetListener {
    protected final VisualProperty<S> vp;
    protected final String columnName;
    private final Map<CyRow, View<?>> rowViewMap;

    public AbstractViewUpdater(VisualProperty<S> vp, String columnName, Map<CyRow, View<?>> rowViewMap) {
        this.vp = vp;
        this.columnName = columnName;
        this.rowViewMap = rowViewMap;
    }

    @Override
    public void handleEvent(RowsSetEvent e) {
        for (RowSetRecord record : e.getColumnRecords(this.columnName)) {
            View<?> v = this.rowViewMap.get(record.getRow());
            if (v == null) continue;
            v.setVisualProperty(this.vp, record.getValue());
        }
    }
}

