/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cytoscape.io.internal.write.graphml.GraphMLAttributeDataTypes;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GraphMLWriter
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String GRAPHML = "graphml";
    private static final String GRAPH = "graph";
    private static final String ID = "id";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String directed = "edgedefault";
    private final CyNetwork network;
    private final Writer writer;
    private final OutputStream outputStream;

    public GraphMLWriter(OutputStream outputStream, CyNetwork network) {
        this.network = network;
        this.outputStream = outputStream;
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    private final void write() throws IOException, ParserConfigurationException, TransformerException {
        Document graphMLDoc = this.createDocument();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        transFactory.setAttribute("indent-number", 4);
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        DOMSource source = new DOMSource(graphMLDoc);
        StreamResult result = new StreamResult(this.writer);
        transformer.transform(source, result);
    }

    private final Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElementNS("http://graphml.graphdrawing.org/xmlns", GRAPHML);
        document.appendChild(root);
        Element graphElm = document.createElement(GRAPH);
        graphElm.setAttribute(directed, "directed");
        graphElm.setAttribute(ID, (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class));
        this.writeAttributes(this.network.getDefaultNodeTable(), document, root, NODE);
        this.writeAttributes(this.network.getDefaultEdgeTable(), document, root, EDGE);
        this.writeAttributes(this.network.getDefaultNetworkTable(), document, root, GRAPH);
        root.appendChild(graphElm);
        this.writeNodes(document, graphElm);
        this.writeEdges(document, graphElm);
        return document;
    }

    private void writeAttributes(CyTable attr, Document doc, Element parent, String forType) {
        for (CyColumn column : attr.getColumns()) {
            Class type = column.getType();
            String tag = GraphMLAttributeDataTypes.getTag(type);
            if (tag == null) {
                tag = GraphMLAttributeDataTypes.STRING.getTypeTag();
            }
            String attrName = column.getName();
            Element keyElm = doc.createElement("key");
            keyElm.setAttribute("for", forType);
            keyElm.setAttribute("attr.name", attrName);
            keyElm.setAttribute("attr.type", tag);
            keyElm.setAttribute(ID, attrName);
            parent.appendChild(keyElm);
        }
    }

    private void writeNodes(Document doc, Element parent) {
        List nodes = this.network.getNodeList();
        CyTable table = this.network.getDefaultNodeTable();
        Collection nodeColumns = table.getColumns();
        for (CyNode node : nodes) {
            Element nodeElm = doc.createElement(NODE);
            nodeElm.setAttribute(ID, node.getSUID().toString());
            CyRow row = this.network.getRow((CyIdentifiable)node);
            this.appendData(row, nodeColumns, doc, nodeElm, (CyIdentifiable)node);
            parent.appendChild(nodeElm);
        }
    }

    private void writeEdges(Document doc, Element parent) {
        List edges = this.network.getEdgeList();
        CyTable table = this.network.getDefaultEdgeTable();
        Collection edgeColumns = table.getColumns();
        for (CyEdge edge : edges) {
            Element edgeElm = doc.createElement(EDGE);
            edgeElm.setAttribute(SOURCE, edge.getSource().getSUID().toString());
            edgeElm.setAttribute(TARGET, edge.getTarget().getSUID().toString());
            CyRow row = this.network.getRow((CyIdentifiable)edge);
            this.appendData(row, edgeColumns, doc, edgeElm, (CyIdentifiable)edge);
            parent.appendChild(edgeElm);
        }
    }

    private void appendData(CyRow row, Collection<CyColumn> columns, Document doc, Element parent, CyIdentifiable obj) {
        for (CyColumn column : columns) {
            Object val = row.get(column.getName(), column.getType());
            if (val == null) continue;
            Element dataElm = doc.createElement("data");
            dataElm.setAttribute("key", column.getName());
            dataElm.setTextContent(val.toString());
            parent.appendChild(dataElm);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.write();
    }

    public void cancel() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            logger.error("Could not close Outputstream for GraphMLWriter.", (Throwable)e);
        }
    }
}

