/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.graphml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLFileFilter
extends BasicCyFileFilter {
    private static final String GRAPHML_NAMESPACE_STRING = "http://graphml.graphdrawing.org/xmlns";
    private static final String GRAPHML_TAG = "<graphml>";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GraphMLFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != this.category) {
            return false;
        }
        String header = this.getHeader(stream, 20);
        if (header.contains(GRAPHML_NAMESPACE_STRING)) {
            return true;
        }
        return header.contains(GRAPHML_TAG);
    }

    public boolean accepts(URI uri, DataCategory category) {
        if (super.accepts(uri, category)) {
            boolean bl;
            block9: {
                InputStream is = uri.toURL().openStream();
                try {
                    bl = this.accepts(is, category);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Error while opening stream: " + uri, (Throwable)e);
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }
}

