/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.rest.AMatReaderParameters;
import org.cytoscape.aMatReader.internal.util.Delimiter;
import org.cytoscape.aMatReader.internal.util.MatrixParser;
import org.cytoscape.aMatReader.internal.util.MatrixTriangleSelector;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class MatrixImportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String> networkNames = new Vector();
    private MatrixTriangleSelector matrixButtons;
    private JComboBox<Delimiter> delimiterComboBox;
    private JComboBox<String> networkComboBox;
    private JCheckBox ignoreZerosCheckBox;
    private JTextField columnNameEntry;
    private JTextField interactionEntry;
    private JCheckBox removeColumnPrefixCheckBox;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private ResourceManager rm;
    private int componentCount = 0;
    private Vector<JComponent> components = new Vector();

    public MatrixImportDialog(ResourceManager rm) {
        super(rm != null ? rm.PARENT_FRAME : null);
        this.rm = rm;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.initComponents();
        double[] rowWeights = new double[this.componentCount + 1];
        int[] rowHeights = new int[this.componentCount + 1];
        for (int i = 0; i < this.componentCount; ++i) {
            JComponent comp = this.components.get(i);
            rowWeights[i] = comp == null ? 1.0 : 0.0;
            int n = rowHeights[i] = comp == null ? 20 : comp.getPreferredSize().height;
            if (comp == null) continue;
            comp.setMinimumSize(comp.getPreferredSize());
        }
        gridBagLayout.columnWeights = new double[]{1.0, 1.0};
        gridBagLayout.columnWidths = new int[]{100, 150};
        gridBagLayout.rowWeights = rowWeights;
        gridBagLayout.rowHeights = rowHeights;
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JComboBox<String> getNetworkComboBox() {
        if (this.networkComboBox == null) {
            this.networkComboBox = new JComboBox();
            this.networkComboBox.setEditable(true);
            this.networkComboBox.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    JTextField editor = (JTextField)MatrixImportDialog.this.networkComboBox.getEditor().getEditorComponent();
                    String name = editor.getText();
                    boolean exists = MatrixImportDialog.this.networkNames.contains(name.trim());
                    Font font = MatrixImportDialog.this.networkComboBox.getFont();
                    editor.setFont(new Font(font.getName(), exists ? 1 : 0, font.getSize()));
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            this.networkComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JTextField editor = (JTextField)MatrixImportDialog.this.networkComboBox.getEditor().getEditorComponent();
                    String name = editor.getText();
                    boolean exists = MatrixImportDialog.this.networkNames.contains(name.trim());
                    Font font = MatrixImportDialog.this.networkComboBox.getFont();
                    editor.setFont(new Font(font.getName(), exists ? 1 : 0, font.getSize()));
                }
            });
            this.resetNetworkComboBox(true);
        }
        return this.networkComboBox;
    }

    private JTextField getInteractionEntry() {
        if (this.interactionEntry == null) {
            this.interactionEntry = new JTextField("interacts with");
        }
        return this.interactionEntry;
    }

    private JTextField getColumnNameEntry() {
        if (this.columnNameEntry == null) {
            this.columnNameEntry = new JTextField();
        }
        return this.columnNameEntry;
    }

    private JCheckBox getRemoveColumnPrefixCheckBox() {
        if (this.removeColumnPrefixCheckBox == null) {
            this.removeColumnPrefixCheckBox = new JCheckBox("Remove column prefix");
            this.removeColumnPrefixCheckBox.setHorizontalAlignment(0);
        }
        return this.removeColumnPrefixCheckBox;
    }

    private void resetNetworkComboBox(boolean changeVal) {
        String name = "New network";
        if (!changeVal) {
            name = (String)this.networkComboBox.getSelectedItem();
        }
        this.networkComboBox.removeAllItems();
        this.networkNames.clear();
        if (this.rm != null) {
            for (CyNetwork net : this.rm.netManager.getNetworkSet()) {
                String netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
                this.networkNames.add(netName);
                this.networkComboBox.addItem(netName);
            }
            if (changeVal) {
                name = this.rm.naming.getSuggestedNetworkTitle(name);
            }
        }
        this.networkComboBox.setSelectedItem(name);
    }

    private JCheckBox getIgnoreZerosCheckBox() {
        if (this.ignoreZerosCheckBox == null) {
            this.ignoreZerosCheckBox = new JCheckBox("Ignore zero values", true);
        }
        return this.ignoreZerosCheckBox;
    }

    private void addRow(String s, JComponent component) {
        GridBagConstraints gbc = new GridBagConstraints();
        int x = 0;
        if (s != null) {
            JLabel label = new JLabel(s);
            label.setLabelFor(component);
            gbc.insets = new Insets(0, 50, 5, 0);
            gbc.gridx = x++;
            gbc.gridy = this.componentCount;
            gbc.anchor = 13;
            this.add((Component)label, gbc);
            gbc.anchor = 17;
        } else {
            gbc.anchor = 10;
            gbc.gridwidth = 2;
        }
        Insets insets = new Insets(0, 0, 5, 0);
        if (component instanceof JButton) {
            insets.left = 5;
            insets.right = 5;
        } else if (s != null) {
            insets.right = 50;
        }
        gbc.insets = insets;
        gbc.gridx = x;
        gbc.gridy = this.componentCount++;
        gbc.fill = 2;
        this.add((Component)component, gbc);
        this.components.add(component);
    }

    private void initComponents() {
        this.addRow("Network: ", this.getNetworkComboBox());
        this.addRow("New column name: ", this.getColumnNameEntry());
        this.addRow("Delimiter: ", this.getDelimiterComboBox());
        this.addRow("Interaction type: ", this.getInteractionEntry());
        this.addRow("", this.getIgnoreZerosCheckBox());
        JLabel label = new JLabel("Select the matrix area(s) to import");
        label.setHorizontalAlignment(0);
        this.addRow(null, label);
        this.addRow(null, this.getMatrixButtons());
        this.addRow(null, this.getRemoveColumnPrefixCheckBox());
        ++this.componentCount;
        this.components.add(null);
        this.addRow(null, this.getButtonPanel());
    }

    public void addActionListener(ActionListener listener) {
        this.getOkButton().addActionListener(listener);
        this.getCancelButton().addActionListener(listener);
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("Import");
            this.getRootPane().setDefaultButton(this.okButton);
        }
        return this.okButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
        }
        return this.cancelButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JComboBox<Delimiter> getDelimiterComboBox() {
        if (this.delimiterComboBox == null) {
            this.delimiterComboBox = new JComboBox<Delimiter>(Delimiter.values());
        }
        return this.delimiterComboBox;
    }

    private MatrixTriangleSelector getMatrixButtons() {
        if (this.matrixButtons == null) {
            this.matrixButtons = new MatrixTriangleSelector(true, true, false);
            this.matrixButtons.setPreferredSize(new Dimension(200, 200));
            this.matrixButtons.setMinimumSize(new Dimension(50, 150));
        }
        return this.matrixButtons;
    }

    public AMatReaderParameters getParameters() {
        AMatReaderParameters params = new AMatReaderParameters();
        params.delimiter = (Delimiter)((Object)this.getDelimiterComboBox().getSelectedItem());
        params.ignoreZeros = this.getIgnoreZerosCheckBox().isSelected();
        params.interactionName = this.getInteractionEntry().getText();
        params.undirected = this.getMatrixButtons().isUndirected();
        params.removeColumnPrefix = this.getRemoveColumnPrefixCheckBox().isSelected();
        params.rowNames = this.getMatrixButtons().hasRowNames();
        params.columnNames = this.getMatrixButtons().hasColumnNames();
        return params;
    }

    public String getColumnName() {
        return this.getColumnNameEntry().getText();
    }

    public String getNetworkName() {
        return (String)this.getNetworkComboBox().getSelectedItem();
    }

    public CyNetwork getNetwork() {
        for (CyNetwork network : this.rm.netManager.getNetworkSet()) {
            String name = (String)this.networkComboBox.getEditor().getItem();
            if (!((String)network.getRow((CyIdentifiable)network).get("name", String.class)).equals(name)) continue;
            return network;
        }
        return null;
    }

    public void updateOptions(String name, MatrixParser.MatrixParameters prediction, boolean newCollection) {
        this.getMatrixButtons().setButtons(prediction.hasRowNames, prediction.hasColumnNames, null);
        this.getDelimiterComboBox().setSelectedItem((Object)prediction.delimiter);
        this.getColumnNameEntry().setText(name);
        boolean prefixed = !prediction.columnPrefix.isEmpty();
        JCheckBox cb = this.getRemoveColumnPrefixCheckBox();
        cb.setVisible(prefixed);
        cb.setSelected(prefixed);
        if (prefixed) {
            cb.setText("Remove column prefix: '" + prediction.columnPrefix + "'");
        } else {
            cb.setSelected(false);
        }
        this.resetNetworkComboBox(false);
        if (newCollection) {
            this.getNetworkComboBox().setSelectedItem(name);
        }
    }
}

