/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.aMatReader.internal.tasks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.aMatReader.internal.ResourceManager;
import org.cytoscape.aMatReader.internal.rest.AMatReaderParameters;
import org.cytoscape.aMatReader.internal.rest.AMatReaderResource;
import org.cytoscape.aMatReader.internal.tasks.AMatReaderTask;
import org.cytoscape.aMatReader.internal.util.MatrixImportDialog;
import org.cytoscape.aMatReader.internal.util.MatrixParser;
import org.cytoscape.aMatReader.internal.util.ResettableBufferedReader;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;

public class AMatReaderWrapperTask
extends AbstractTask
implements CyNetworkReader,
ObservableTask {
    private static AMatReaderResource.AMatReaderResponse result;
    private static MatrixImportDialog dialog;
    private static ResettableBufferedReader reader;
    private static ArrayDeque<String> names;
    private static HashMap<String, InputStream> inputStreamMap;
    private CyNetwork network = null;
    String networkName = "";
    final ResourceManager resourceManager;

    @ProvidesTitle
    public String getTitle() {
        return "Adjacency Matrix Reader";
    }

    public AMatReaderWrapperTask(InputStream inputStream, String name, ResourceManager rm) {
        this.resourceManager = rm;
        if (name.startsWith("file:")) {
            try {
                File f = new File(name.substring(5, name.length()));
                inputStream = new FileInputStream(f);
                name = f.getName();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            name = this.resourceManager.naming.getSuggestedNetworkTitle(name);
        }
        inputStreamMap.put(name, inputStream);
        names.add(name);
    }

    public AMatReaderWrapperTask(File[] files, String name, ResourceManager rm) throws FileNotFoundException {
        this.resourceManager = rm;
        for (File f : files) {
            inputStreamMap.put(f.getName(), new FileInputStream(f));
            names.add(f.getName());
        }
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        return null;
    }

    public void doImport(ResettableBufferedReader reader) {
        dialog = this.getDialog();
        AMatReaderParameters params = dialog.getParameters();
        this.network = dialog.getNetwork();
        this.networkName = dialog.getNetworkName();
        this.importMatrix(reader, dialog.getColumnName(), params);
    }

    private HashMap<String, Object> buildContext(AMatReaderParameters params) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("delimiter", (Object)params.delimiter);
        context.put("ignoreZeros", params.ignoreZeros);
        context.put("interactionName", params.interactionName);
        context.put("removeColumnPrefix", params.removeColumnPrefix);
        context.put("undirected", params.undirected);
        context.put("rowNames", params.rowNames);
        context.put("columnNames", params.columnNames);
        return context;
    }

    private void importMatrix(ResettableBufferedReader reader, String name, AMatReaderParameters params) {
        final AMatReaderTask task = this.network != null ? new AMatReaderTask(this.network, reader, name, this.resourceManager) : new AMatReaderTask(reader, name, this.resourceManager);
        HashMap<String, Object> context = this.buildContext(params);
        this.resourceManager.taskManager.setExecutionContext(context);
        TaskObserver to = new TaskObserver(){

            public void taskFinished(ObservableTask task2) {
            }

            public void allFinished(FinishStatus finishStatus) {
                if (finishStatus.getType() == FinishStatus.Type.SUCCEEDED) {
                    CyNetwork newNetwork = task.getNetworks()[0];
                    if (AMatReaderWrapperTask.this.network == null && newNetwork != null) {
                        AMatReaderWrapperTask.this.resourceManager.netManager.addNetwork(newNetwork);
                        newNetwork.getRow((CyIdentifiable)newNetwork).set("name", (Object)AMatReaderWrapperTask.this.networkName);
                        CyRootNetwork root = ((CySubNetwork)newNetwork).getRootNetwork();
                        root.getRow((CyIdentifiable)root).set("name", (Object)AMatReaderWrapperTask.this.networkName);
                    }
                    String name = names.poll();
                    AMatReaderWrapperTask.this.updateDialog(name);
                } else {
                    Exception e = finishStatus.getException();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                    AMatReaderWrapperTask.this.reset();
                }
            }
        };
        this.resourceManager.taskManager.execute(new TaskIterator(new Task[]{task}), to);
    }

    private void updateDialog(String name) {
        if (name != null) {
            InputStream is = inputStreamMap.get(name);
            reader = new ResettableBufferedReader(is);
            MatrixParser.MatrixParameters prediction = new MatrixParser.MatrixParameters();
            try {
                prediction = MatrixParser.predictParameters(reader);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            dialog.updateOptions(name, prediction, false);
        } else {
            this.reset();
        }
    }

    private MatrixImportDialog getDialog() {
        if (dialog == null) {
            dialog = new MatrixImportDialog(this.resourceManager);
            dialog.setSize(400, 600);
            dialog.pack();
            dialog.setLocationRelativeTo(this.resourceManager.PARENT_FRAME);
            dialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == dialog.getOkButton()) {
                        AMatReaderWrapperTask.this.doImport(reader);
                    } else {
                        AMatReaderWrapperTask.this.reset();
                    }
                }
            });
        }
        return dialog;
    }

    private void reset() {
        dialog.setVisible(false);
        dialog = null;
        inputStreamMap.clear();
        names.clear();
    }

    public void showDialog() {
        if (dialog == null) {
            return;
        }
        if (!dialog.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String name = names.poll();
                    InputStream is = inputStreamMap.get(name);
                    reader = new ResettableBufferedReader(is);
                    try {
                        MatrixParser.MatrixParameters prediction = MatrixParser.predictParameters(reader);
                        AMatReaderWrapperTask.this.getDialog().updateOptions(name, prediction, true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    dialog.setVisible(true);
                }
            });
        }
    }

    public void run(TaskMonitor taskMonitor) {
        if (dialog == null) {
            dialog = this.getDialog();
            this.showDialog();
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        return (R)((Object)result);
    }

    public void cancel() {
        if (dialog != null) {
            dialog.setVisible(false);
            dialog = null;
        }
    }

    public CyNetwork[] getNetworks() {
        return null;
    }

    static {
        names = new ArrayDeque();
        inputStreamMap = new HashMap();
    }
}

