/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

public class Range {
    public static Range EMPTY = new Range(0, 0);
    double min;
    double max;

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double width() {
        return this.max - this.min;
    }

    public void union(Range other) {
        if (this.min > other.min) {
            this.min = other.min;
        }
        if (this.max < other.max) {
            this.max = other.max;
        }
    }

    public void intersect(Range other) {
        if (this.min < other.min) {
            this.min = other.min;
        }
        if (this.max > other.max) {
            this.max = other.max;
        }
    }

    public double product() {
        return this.max / this.min;
    }

    public double normalize(double x) {
        return (x - this.min) / this.width();
    }

    public double normalize(double x, boolean isLog) {
        if (isLog) {
            return x / this.min / this.product();
        }
        return this.normalize(x);
    }

    public void set(double mini, double maxi) {
        this.min = mini;
        this.max = maxi;
    }

    public Range() {
        this(0, 1);
    }

    public Range(float mini, float maxi) {
        this.min = mini;
        this.max = maxi;
    }

    public Range(double mini, double maxi) {
        this.min = mini;
        this.max = maxi;
    }

    public Range(int mini, int maxi) {
        this.min = mini;
        this.max = maxi;
    }

    public String toString() {
        return "[" + this.min + " - " + this.max + "]";
    }

    public boolean contains(double d) {
        return this.min <= d && this.max > d;
    }
}

