/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.oneD;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import org.cytoscape.cyChart.internal.model.LogarithmicAxis;
import org.cytoscape.cyChart.internal.model.Range;

public class FrameScaleConverter {
    double HACK = 0.0;
    double FUDGE = 0.0;

    public Range frameToScaleRange(double anchor, double moving, XYChart<Number, Number> theChart) {
        double left = Math.min(anchor, moving);
        double right = Math.max(anchor, moving);
        double x0 = this.frameToScale(left, theChart, false);
        double x1 = this.frameToScale(right, theChart, false);
        return new Range(x0, x1);
    }

    public double frameToScale(double framePosition, XYChart<Number, Number> theChart, boolean isYAxis) {
        framePosition -= this.HACK;
        Bounds bounds = this.getChartPlotBounds(theChart);
        double frameLength = isYAxis ? bounds.getHeight() : bounds.getWidth();
        ValueAxis axis = (ValueAxis)(isYAxis ? theChart.getYAxis() : theChart.getXAxis());
        if (axis instanceof LogarithmicAxis) {
            LogarithmicAxis logAxis = (LogarithmicAxis)axis;
            double outScale = logAxis.getValueForDisplay(framePosition).doubleValue();
            return outScale;
        }
        double scaleMin = axis.getLowerBound();
        double scaleMax = axis.getUpperBound();
        double relativePosition = framePosition / frameLength;
        double scaleLength = scaleMax - scaleMin;
        double offset = scaleMin;
        int sign = 0;
        if (isYAxis) {
            offset = scaleMax;
            sign = -1;
        } else {
            offset = scaleMin;
            sign = 1;
        }
        double outScale = offset + (double)sign * relativePosition * scaleLength;
        boolean VERBOSE = false;
        if (VERBOSE) {
            String axisName = isYAxis ? "Y" : "X";
            System.out.println(String.format("%s AxisBounds:[%.1f, - %.1f] FrameLength:[%.1f] %.1f -> %.2f", axisName, scaleMin, scaleMax, frameLength, framePosition, outScale));
        }
        return outScale;
    }

    public double scaleToFrame(double scaleValue, XYChart<Number, Number> theChart, boolean isYAxis) {
        scaleValue += this.FUDGE;
        ValueAxis axis = (ValueAxis)(isYAxis ? theChart.getYAxis() : theChart.getXAxis());
        if (axis instanceof LogarithmicAxis) {
            LogarithmicAxis logAxis = (LogarithmicAxis)axis;
            double outFrame = logAxis.getDisplayPosition(scaleValue);
            return outFrame;
        }
        Bounds bounds = this.getChartPlotBounds(theChart);
        double widthOrHeight = isYAxis ? bounds.getHeight() : bounds.getWidth();
        double lower = axis.getLowerBound();
        double upper = axis.getUpperBound();
        double relativePosition = (scaleValue - lower) / (upper - lower);
        if (isYAxis) {
            relativePosition = 1.0 - relativePosition;
        }
        double frameVal = relativePosition * widthOrHeight;
        boolean VERBOSE = false;
        if (VERBOSE) {
            String axisName = isYAxis ? "Y" : "X";
            System.out.println(String.format("scaleToFrame: dim: %s AxisBounds:[%.1f, - %.1f] FrameLength:[%.1f] %.1f <- %.2f", axisName, lower, upper, widthOrHeight, frameVal, scaleValue));
        }
        return frameVal;
    }

    public Point2D scaleToFrame(Point2D pt, XYChart<Number, Number> theChart) {
        Point2D offset = this.getChartOffset(theChart);
        double x = this.scaleToFrame(pt.getX(), theChart, false) + offset.getX() + 5.0;
        double y = this.scaleToFrame(pt.getY(), theChart, true) + offset.getY() + 5.0;
        return new Point2D(x, y);
    }

    public Bounds getChartPlotBounds(XYChart<Number, Number> theChart) {
        Node chartPlotArea = theChart.lookup(".chart-plot-background");
        return chartPlotArea == null ? null : chartPlotArea.getLayoutBounds();
    }

    public Point2D getChartOffset(XYChart<Number, Number> theChart) {
        Node chartPlotArea = theChart.lookup(".chart-plot-background");
        return chartPlotArea == null ? null : new Point2D(chartPlotArea.getLayoutX(), chartPlotArea.getLayoutY());
    }
}

