/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal;

import java.util.HashMap;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.cyChart.internal.model.Range;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;

public class FilterBuilder {
    String xColumnName;
    Range xRange;
    String yColumnName;
    Range yRange;

    public FilterBuilder(String columnName, Range r) {
        this.xColumnName = columnName;
        this.xRange = r;
    }

    public FilterBuilder(String xcolumn, Range xRange, String yCol, Range inYRange) {
        this(xcolumn, xRange);
        this.yColumnName = yCol;
        this.yRange = inYRange;
    }

    public void makeCompositeFilter(CyServiceRegistrar registrar) {
        CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)registrar.getService(CommandExecutorTaskFactory.class);
        TaskManager taskManager = (TaskManager)registrar.getService(TaskManager.class);
        if (commandTF != null && taskManager != null) {
            this.execFilterCommand(taskManager, commandTF, this.makeComposite());
        } else {
            System.err.println("CommandExecutorTaskFactory or TaskManager is null");
        }
    }

    private String makeComposite() {
        String filter1 = this.makeString(true);
        String filter2 = this.makeString(false);
        StringBuilder compos = new StringBuilder();
        compos.append("{\n\"id\" : \"CompositeFilter\",\n");
        compos.append("\"parameters\" : {\n \"type\" : \"ALL\"\n},\n");
        compos.append("\"transformers\" : [ \n");
        compos.append(filter1 + ", \n" + filter2);
        compos.append("] \n}\n");
        return compos.toString();
    }

    public void makeSingleFilter(CyServiceRegistrar registrar) {
        CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)registrar.getService(CommandExecutorTaskFactory.class);
        TaskManager taskManager = (TaskManager)registrar.getService(TaskManager.class);
        if (commandTF != null && taskManager != null) {
            this.execFilterCommand(taskManager, commandTF, this.makeString(true));
        } else {
            System.err.println("CommandExecutorTaskFactory or TaskManager is null");
        }
    }

    private void execFilterCommand(TaskManager<?, ?> taskManager, CommandExecutorTaskFactory commandTF, String json) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", "cychart filter");
        args.put("json", json);
        TaskIterator ti = commandTF.createTaskIterator("filter", "create", args, null);
        taskManager.execute(ti);
    }

    public String makeString(boolean isX) {
        String columnName;
        String criterion;
        if (isX) {
            criterion = String.format("[ %.4f, %.4f ]", this.xRange.min(), this.xRange.max());
            columnName = this.xColumnName;
        } else {
            criterion = String.format("[ %.4f, %.4f ]", this.yRange.min(), this.yRange.max());
            columnName = this.yColumnName;
        }
        StringBuilder buildr = new StringBuilder();
        buildr.append("{\n");
        buildr.append("\"id\" : \"ColumnFilter\", \n");
        buildr.append("\"parameters\" : {\n");
        this.addLine(buildr, "predicate", "\"BETWEEN\"", true);
        this.addLine(buildr, "criterion", criterion, true);
        this.addLine(buildr, "caseSensitive", "false", true);
        this.addLine(buildr, "type", "\"nodes\"", true);
        this.addLine(buildr, "anyMatch", "true", true);
        this.addLine(buildr, "columnName", this.inQuotes(columnName), false);
        buildr.append("\n }\n}");
        return buildr.toString();
    }

    private String inQuotes(String a) {
        return "\"" + a + "\"";
    }

    void addLine(StringBuilder b, String attr, String value, boolean addComma) {
        b.append(this.inQuotes(attr) + " : " + value);
        if (addComma) {
            b.append(",\n");
        }
    }
}

