/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal;

import java.util.Properties;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.cyChart.internal.charts.oneD.ColumnFilterTaskFactory;
import org.cytoscape.cyChart.internal.charts.twoD.Column2DFilterTaskFactory;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.cyChart.internal.tasks.HistogramFilterTaskFactory;
import org.cytoscape.cyChart.internal.tasks.ScatterFilterTaskFactory;
import org.cytoscape.cyChart.internal.tasks.VersionTaskFactory;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        ServiceReference ref = bc.getServiceReference(CySwingApplication.class.getName());
        if (ref == null) {
            return;
        }
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyChartManager manager = new CyChartManager(registrar);
        String version = bc.getBundle().getVersion().toString();
        manager.setVersion(version);
        HistogramFilterTaskFactory histoChart = new HistogramFilterTaskFactory(manager);
        Properties props = new Properties();
        props.setProperty("menuGravity", "0.1");
        props.setProperty("preferredMenu", "Tools");
        props.setProperty("title", "Plot Histogram...");
        props.setProperty("inMenuBar", "true");
        props.setProperty("commandNamespace", "cychart");
        props.setProperty("command", "histogram");
        props.setProperty("commandDescription", "Launch a histogram chart in a separate window");
        props.setProperty("commandLongDescription", "Launch a Cytoscap CyChart in a separate window.  ");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, (Object)histoChart, TaskFactory.class, props);
        ColumnFilterTaskFactory histoChart2 = new ColumnFilterTaskFactory(manager);
        props = new Properties();
        props.setProperty("title", "Plot Histogram...");
        props.setProperty("inMenuBar", "true");
        props.setProperty("commandNamespace", "cychart");
        props.setProperty("command", "histogram");
        props.setProperty("commandDescription", "Launch a Histogram chart in a separate window");
        props.setProperty("commandLongDescription", "Launch a Cytoscap CyChart in a separate window.  ");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, (Object)histoChart2, TableColumnTaskFactory.class, props);
        ScatterFilterTaskFactory scatChart = new ScatterFilterTaskFactory(manager);
        props = new Properties();
        props.setProperty("preferredMenu", "Tools");
        props.setProperty("title", "Plot Scatter...");
        props.setProperty("menuGravity", "0.3");
        props.setProperty("inMenuBar", "true");
        props.setProperty("commandNamespace", "cychart");
        props.setProperty("command", "scatter");
        props.setProperty("commandDescription", "Launch a Scatter chart in a separate window");
        props.setProperty("commandLongDescription", "Launch a Cytoscap CyChart in a separate window.  ");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"id\":\"my window\"}");
        this.registerService(bc, (Object)scatChart, TaskFactory.class, props);
        Column2DFilterTaskFactory scatChart2 = new Column2DFilterTaskFactory(manager);
        props = new Properties();
        props.setProperty("title", "Plot Scatter...");
        props.setProperty("commandNamespace", "cychart");
        props.setProperty("command", "column");
        props.setProperty("commandDescription", "Launch a Scatter chart in a separate window");
        props.setProperty("commandLongDescription", "Launch a Cytoscap CyChart in a separate window.  ");
        props.setProperty("commandSupportsJSON", "false");
        this.registerService(bc, (Object)scatChart2, TableColumnTaskFactory.class, props);
        VersionTaskFactory versionTask = new VersionTaskFactory(version);
        props = new Properties();
        props.setProperty("commandNamespace", "cychart");
        props.setProperty("command", "version");
        props.setProperty("commandDescription", "Display the CyChart version");
        props.setProperty("commandLongDescription", "Display the version of the CyChart app.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{\"version\":\"1.0\"}");
        this.registerService(bc, (Object)versionTask, TaskFactory.class, props);
        this.registerService(bc, (Object)histoChart, HistogramFilterTaskFactory.class, props);
    }
}

