/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.util;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.util.AttributeValueMatcher;

public class DefaultAttributeValueMatcher
implements AttributeValueMatcher {
    @Override
    public boolean matched(CyIdentifiable entry1, CyColumn attr1, CyIdentifiable entry2, CyColumn attr2) {
        if (entry1 == null || attr1 == null || entry2 == null || attr2 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (entry1 == entry2 && attr1 == attr2) {
            return true;
        }
        CyTable table1 = attr1.getTable();
        CyTable table2 = attr2.getTable();
        CyRow row1 = table1.getRow((Object)entry1.getSUID());
        CyRow row2 = table2.getRow((Object)entry2.getSUID());
        Class type1 = attr1.getType();
        Class type2 = attr2.getType();
        if (!List.class.isAssignableFrom(type1) && !List.class.isAssignableFrom(type2)) {
            Object val1 = row1.get(attr1.getName(), type1);
            Object val2 = row2.get(attr2.getName(), type2);
            if (val1 == null || val2 == null) {
                return false;
            }
            return val1.equals(val2);
        }
        if (!List.class.isAssignableFrom(type1) || !List.class.isAssignableFrom(type2)) {
            Object o;
            List l;
            if (List.class.isAssignableFrom(type1)) {
                l = (List)row1.get(attr1.getName(), List.class);
                o = row2.get(attr2.getName(), type2);
            } else {
                l = (List)row2.get(attr2.getName(), List.class);
                o = row1.get(attr1.getName(), type1);
            }
            if (l == null || o == null) {
                return false;
            }
            int nl = l.size();
            for (int il = 0; il < nl; ++il) {
                Object o2 = l.get(il);
                if (!o.equals(o2)) continue;
                return true;
            }
            return false;
        }
        List l1 = (List)row1.get(attr1.getName(), List.class);
        List l2 = (List)row2.get(attr2.getName(), List.class);
        int nl1 = l1.size();
        int nl2 = l2.size();
        for (int il1 = 0; il1 < nl1; ++il1) {
            Object o1 = l1.get(il1);
            for (int il2 = 0; il2 < nl2; ++il2) {
                Object o2 = l2.get(il2);
                if (!o1.equals(o2)) continue;
                return true;
            }
        }
        return false;
    }
}

