/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;

public enum ColumnType {
    STRING(String.class, new CastService<String>(){

        @Override
        public String cast(Object from) {
            return from.toString();
        }
    }),
    INTEGER(Integer.class, new CastService<Integer>(){

        @Override
        public Integer cast(Object from) {
            return Integer.valueOf(from.toString());
        }
    }),
    LONG(Long.class, new CastService<Long>(){

        @Override
        public Long cast(Object from) {
            return Long.valueOf(from.toString());
        }
    }),
    DOUBLE(Double.class, new CastService<Double>(){

        @Override
        public Double cast(Object from) {
            return Double.valueOf(from.toString());
        }
    }),
    BOOLEAN(Boolean.class, new CastService<Boolean>(){

        @Override
        public Boolean cast(Object from) {
            return Boolean.valueOf(from.toString());
        }
    }),
    LIST_STRING(String.class, null, true),
    LIST_INTEGER(Integer.class, null, true),
    LIST_LONG(Long.class, null, true),
    LIST_DOUBLE(Double.class, null, true),
    LIST_BOOLEAN(Boolean.class, null, true);

    private Class<?> type;
    private boolean isList;
    private final CastService<?> castServ;
    private static final Map<Class<?>, ColumnType> plainTypes;
    private static final Map<Class<?>, ColumnType> listTypes;

    private <T> ColumnType(Class<T> type, CastService<T> castServ) {
        this(type, castServ, false);
    }

    private <T> ColumnType(Class<T> type, CastService<T> castServ, boolean isList) {
        this.type = type;
        this.isList = isList;
        this.castServ = castServ == null ? new CastService<T>(){

            @Override
            public T cast(Object from) {
                throw new UnsupportedOperationException();
            }
        } : castServ;
    }

    public boolean isList() {
        return this.isList;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        if (this.isList) {
            return "List<" + this.type.getSimpleName() + ">";
        }
        return this.type.getSimpleName();
    }

    public static ColumnType getType(CyColumn col) {
        Class type = col.getType();
        if (List.class.isAssignableFrom(type)) {
            return listTypes.get(col.getListElementType());
        }
        return plainTypes.get(type);
    }

    public static boolean isConvertable(ColumnType from, ColumnType to) {
        if (from == to) {
            return true;
        }
        if (to == STRING) {
            return true;
        }
        if (from == INTEGER && (to == DOUBLE || to == LONG)) {
            return true;
        }
        if (from == LONG && to == DOUBLE) {
            return true;
        }
        return to.isList && ColumnType.isConvertable(from.toPlain(), to.toPlain());
    }

    public ColumnType toPlain() {
        return plainTypes.get(this.type);
    }

    public ColumnType toList() {
        return listTypes.get(this.type);
    }

    public Object castService(Object from) {
        return this.castServ.cast(from);
    }

    public static ColumnType getResonableCompatibleConvertionType(Set<ColumnType> types) {
        Iterator<ColumnType> it = types.iterator();
        ColumnType curr = it.next();
        boolean li = curr.isList;
        ColumnType ret = curr.toPlain();
        while (it.hasNext()) {
            curr = it.next();
            ColumnType plain = curr.toPlain();
            if (!ColumnType.isConvertable(plain, ret)) {
                ColumnType columnType = ret = ColumnType.isConvertable(ret, plain) ? plain : STRING;
            }
            if (li) continue;
            li = curr.isList;
        }
        return li ? ret.toList() : ret;
    }

    public static Set<ColumnType> getConvertibleTypes(ColumnType fromType) {
        EnumSet<ColumnType> types = EnumSet.noneOf(ColumnType.class);
        for (ColumnType type : ColumnType.values()) {
            if (!ColumnType.isConvertable(fromType, type)) continue;
            types.add(type);
        }
        return types;
    }

    static {
        plainTypes = new HashMap();
        listTypes = new HashMap();
        for (ColumnType ct : ColumnType.values()) {
            if (ct.isList) {
                listTypes.put(ct.type, ct);
                continue;
            }
            plainTypes.put(ct.type, ct);
        }
    }

    static interface CastService<T> {
        public T cast(Object var1);
    }
}

