/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.task;

import java.util.ArrayList;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollector;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictHandler;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictManager;
import org.cytoscape.network.merge.internal.conflict.DefaultAttributeConflictHandler;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class HandleConflictsTask
extends AbstractTask {
    private AttributeConflictCollector conflictCollector;

    public HandleConflictsTask(AttributeConflictCollector conflictCollector) {
        this.conflictCollector = conflictCollector;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setStatusMessage("Handle conflicts.\n\nIt may take a while.\nPlease wait...");
        taskMonitor.setProgress(0.0);
        int nBefore = this.conflictCollector.getMapToGOAttr().size();
        ArrayList<AttributeConflictHandler> conflictHandlers = new ArrayList<AttributeConflictHandler>();
        DefaultAttributeConflictHandler conflictHandler = new DefaultAttributeConflictHandler();
        conflictHandlers.add(conflictHandler);
        AttributeConflictManager conflictManager = new AttributeConflictManager(this.conflictCollector, conflictHandlers);
        conflictManager.handleConflicts();
        int nAfter = this.conflictCollector.getMapToGOAttr().size();
        taskMonitor.setProgress(1.0);
        taskMonitor.setStatusMessage("Successfully handled " + (nBefore - nAfter) + " table column conflicts. " + nAfter + " conflicts remains.");
    }
}

