/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.model;

import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.network.merge.internal.task.NetworkMergeCommandTask;
import org.cytoscape.network.merge.internal.util.ColumnType;

public class ColumnMergeRecord {
    public HashMap<CyNetwork, String> columnNames = new HashMap();
    public String outName;
    public ColumnType outType;

    public ColumnMergeRecord(String str, List<CyNetwork> netw) {
        String[] names = str.split(",");
        int size = names.length;
        if (size != netw.size() + 2) {
            throw new IllegalArgumentException("Wrong number of arguments, given size of network list");
        }
        for (int i = 0; i < size - 2; ++i) {
            this.columnNames.put(netw.get(i), names[i]);
        }
        this.outName = names[size - 2];
        this.outType = ColumnType.STRING;
    }

    public void dump() {
        System.out.println(this.outName + " # " + this.outType.toString());
        for (CyNetwork net : this.columnNames.keySet()) {
            System.out.println(NetworkMergeCommandTask.getNetworkName(net) + ": " + this.columnNames.get(net));
        }
        System.out.println("\n");
    }
}

