/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.conflict;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictCollector;

public class AttributeConflictCollectorImpl
implements AttributeConflictCollector {
    protected Map<CyIdentifiable, Map<CyColumn, Conflicts>> mapToGOToAttrConflicts = new HashMap<CyIdentifiable, Map<CyColumn, Conflicts>>();

    @Override
    public boolean isEmpty() {
        return this.mapToGOToAttrConflicts.isEmpty();
    }

    @Override
    public Map<CyIdentifiable, CyColumn> getMapToGOAttr() {
        HashMap<CyIdentifiable, CyColumn> mapToGOAttr = new HashMap<CyIdentifiable, CyColumn>();
        for (Map.Entry<CyIdentifiable, Map<CyColumn, Conflicts>> entry : this.mapToGOToAttrConflicts.entrySet()) {
            CyIdentifiable go = entry.getKey();
            for (CyColumn attr : entry.getValue().keySet()) {
                mapToGOAttr.put(go, attr);
            }
        }
        return mapToGOAttr;
    }

    @Override
    public Map<CyIdentifiable, CyColumn> getConflicts(CyIdentifiable to, CyColumn toAttr) {
        if (to == null || toAttr == null) {
            throw new NullPointerException();
        }
        Map<CyColumn, Conflicts> mapToAttrConflicts = this.mapToGOToAttrConflicts.get(to);
        if (mapToAttrConflicts == null) {
            return null;
        }
        return mapToAttrConflicts.get((Object)toAttr).mapFromGOFromAttr;
    }

    @Override
    public void addConflict(CyIdentifiable from, CyColumn fromAttr, CyIdentifiable to, CyColumn toAttr) {
        Conflicts conflicts;
        if (from == null || fromAttr == null || to == null || toAttr == null) {
            throw new NullPointerException();
        }
        Map<CyColumn, Conflicts> mapToAttrConflicts = this.mapToGOToAttrConflicts.get(to);
        if (mapToAttrConflicts == null) {
            mapToAttrConflicts = new HashMap<CyColumn, Conflicts>();
            this.mapToGOToAttrConflicts.put(to, mapToAttrConflicts);
        }
        if ((conflicts = mapToAttrConflicts.get(toAttr)) == null) {
            conflicts = new Conflicts();
            mapToAttrConflicts.put(toAttr, conflicts);
        }
        conflicts.addConflict(from, fromAttr);
    }

    @Override
    public boolean removeConflicts(CyIdentifiable to, CyColumn toAttr) {
        if (to == null || toAttr == null) {
            throw new NullPointerException();
        }
        Map<CyColumn, Conflicts> mapToAttrConflicts = this.mapToGOToAttrConflicts.get(to);
        if (mapToAttrConflicts == null) {
            return false;
        }
        if (mapToAttrConflicts.get(toAttr) == null) {
            return false;
        }
        mapToAttrConflicts.remove(toAttr);
        return true;
    }

    @Override
    public boolean removeConflict(CyIdentifiable from, CyColumn fromAttr, CyIdentifiable to, CyColumn toAttr) {
        if (from == null || fromAttr == null || to == null || toAttr == null) {
            throw new NullPointerException();
        }
        Map<CyColumn, Conflicts> mapToAttrConflicts = this.mapToGOToAttrConflicts.get(to);
        if (mapToAttrConflicts == null) {
            return false;
        }
        Conflicts conflicts = mapToAttrConflicts.get(toAttr);
        if (conflicts == null) {
            return false;
        }
        boolean ret = conflicts.removeConflict(from, fromAttr);
        if (ret && conflicts.mapFromGOFromAttr.isEmpty()) {
            mapToAttrConflicts.remove(toAttr);
            if (mapToAttrConflicts.isEmpty()) {
                this.mapToGOToAttrConflicts.remove(to);
            }
        }
        return ret;
    }

    protected class Conflicts {
        public Map<CyIdentifiable, CyColumn> mapFromGOFromAttr = new HashMap<CyIdentifiable, CyColumn>();

        public void addConflict(CyIdentifiable from, CyColumn fromAttr) {
            this.mapFromGOFromAttr.put(from, fromAttr);
        }

        public boolean removeConflict(CyIdentifiable from, CyColumn fromAttr) {
            CyColumn attr = this.mapFromGOFromAttr.get(from);
            if (attr == null || attr != fromAttr) {
                return false;
            }
            this.mapFromGOFromAttr.remove(from);
            return true;
        }
    }
}

