/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.cytoscape.analyzer.util.ComplexParam;
import org.cytoscape.analyzer.util.LineReader;

public class Points2D
implements ComplexParam {
    private Point2D.Double[] points;

    public Points2D(String[] aArgs, LineReader aReader) throws IOException {
        this.load(aArgs, aReader);
    }

    public Points2D(List<Point2D.Double> aPoints) {
        this.points = new Point2D.Double[aPoints.size()];
        aPoints.toArray(this.points);
    }

    public Points2D(Set<Point2D.Double> aPoints) {
        this.points = new Point2D.Double[aPoints.size()];
        aPoints.toArray(this.points);
    }

    public Points2D(Point2D.Double[] aPoints) {
        this.points = aPoints != null ? aPoints : new Point2D.Double[]{};
    }

    public Point2D.Double[] getPoints() {
        return this.points;
    }

    public double[] getRangeX() {
        if (this.points.length == 0) {
            throw new IllegalStateException();
        }
        double[] range = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        for (Point2D.Double point : this.points) {
            if (point.x < range[0]) {
                range[0] = point.x;
            }
            if (!(point.x > range[1])) continue;
            range[1] = point.x;
        }
        return range;
    }

    @Override
    public void load(String[] aArgs, LineReader aReader) throws IOException {
        int itemCount = Integer.parseInt(aArgs[0]);
        this.points = new Point2D.Double[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            String[] coords = aReader.readLine().split("\\t");
            double x = Double.parseDouble(coords[0]);
            double y = Double.parseDouble(coords[1]);
            this.points[i] = new Point2D.Double(x, y);
        }
    }

    @Override
    public void save(FileWriter aWriter, boolean aSaveArgs) throws IOException {
        int itemCount = this.points.length;
        if (aSaveArgs) {
            aWriter.write(String.valueOf(itemCount) + "\n");
        }
        for (int i = 0; i < itemCount; ++i) {
            double x = this.points[i].x;
            double y = this.points[i].y;
            String xStr = x < 9.223372036854776E18 && Math.floor(x) != x ? String.valueOf(x) : String.valueOf((long)x);
            String yStr = y < 9.223372036854776E18 && Math.floor(y) != y ? String.valueOf(y) : String.valueOf((long)y);
            aWriter.write(xStr + "\t" + yStr + "\n");
        }
    }
}

