/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.awt.GridBagConstraints;
import java.util.HashMap;
import java.util.Map;

public class EasyGBC
extends GridBagConstraints {
    static final Map<String, Integer> anchors = new HashMap<String, Integer>();

    public EasyGBC() {
        this.reset();
    }

    public EasyGBC reset() {
        this.gridx = 0;
        this.gridy = 0;
        this.gridwidth = 1;
        this.gridheight = 1;
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.fill = 0;
        this.insets.set(0, 0, 0, 0);
        return this;
    }

    public EasyGBC noExpand() {
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.fill = 0;
        return this;
    }

    public EasyGBC expandVert() {
        this.weightx = 0.0;
        this.weighty = 1.0;
        this.fill = 3;
        return this;
    }

    public EasyGBC expandHoriz() {
        this.weightx = 1.0;
        this.weighty = 0.0;
        this.fill = 2;
        return this;
    }

    public EasyGBC expandBoth() {
        this.weightx = 1.0;
        this.weighty = 1.0;
        this.fill = 1;
        return this;
    }

    public EasyGBC right() {
        ++this.gridx;
        return this;
    }

    public EasyGBC left() {
        --this.gridx;
        return this;
    }

    public EasyGBC down() {
        this.gridx = 0;
        ++this.gridy;
        return this;
    }

    public EasyGBC up() {
        this.gridx = 0;
        --this.gridy;
        return this;
    }

    public EasyGBC position(int x, int y) {
        this.gridx = x;
        this.gridy = y;
        return this;
    }

    public EasyGBC noSpan() {
        this.gridwidth = 1;
        this.gridheight = 1;
        return this;
    }

    public EasyGBC spanHoriz(int n) {
        this.gridwidth = n;
        this.gridheight = 1;
        return this;
    }

    public EasyGBC insets(int t, int l, int b, int r) {
        this.insets.set(t, l, b, r);
        return this;
    }

    public EasyGBC noInsets() {
        this.insets.set(0, 0, 0, 0);
        return this;
    }

    public EasyGBC anchor(String str) {
        this.anchor = anchors.get(str);
        return this;
    }

    static {
        anchors.put("north", 11);
        anchors.put("northwest", 18);
        anchors.put("northeast", 12);
        anchors.put("west", 17);
        anchors.put("south", 15);
        anchors.put("southwest", 16);
        anchors.put("southeast", 14);
        anchors.put("east", 13);
    }
}

