/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import org.cytoscape.analyzer.util.IntHistogram;

public class DegreeDistribution {
    private static final int MIN_INITIAL_SIZE = 256;
    private static final double GROWTH_FACTOR = 2.0;
    private int[] distribution;
    private int maxDegree;

    public DegreeDistribution(int aNodeCount) {
        int initialSize = Math.max(aNodeCount / 4, 256);
        this.distribution = new int[initialSize];
        this.maxDegree = 0;
    }

    public int getCount(int aDegree) {
        if (0 <= aDegree && aDegree <= this.maxDegree) {
            return this.distribution[aDegree];
        }
        return 0;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public IntHistogram createHistogram() {
        return new IntHistogram(this.distribution, 0, this.maxDegree);
    }

    public void addObservation(int aDegree) {
        if (aDegree >= this.distribution.length) {
            this.ensureCapacity(aDegree + 1);
        }
        if (this.maxDegree < aDegree) {
            this.maxDegree = aDegree;
        }
        int n = aDegree;
        this.distribution[n] = this.distribution[n] + 1;
    }

    private void ensureCapacity(int aCapacity) {
        int currentCap;
        int newCap = currentCap = this.distribution.length;
        while (newCap < aCapacity) {
            newCap = (int)(2.0 * (double)newCap);
        }
        if (newCap != currentCap) {
            int[] newDist = new int[newCap];
            System.arraycopy(this.distribution, 0, newDist, 0, currentCap);
            this.distribution = newDist;
        }
    }
}

