/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.analyzer.util.AttributeSetup;
import org.cytoscape.analyzer.util.Msgs;
import org.cytoscape.analyzer.util.MutInteger;
import org.cytoscape.analyzer.util.NetworkInspection;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;

public class CyNetworkUtils {
    private static String[][] keepAvailableAttributes(CyNetwork aNetwork, Set<String> computedAttr, CyTable table, Set<String> netAnalyzerAttr) {
        ArrayList<String> visualizeAttr = new ArrayList<String>(computedAttr.size() + 1);
        for (String colName : computedAttr) {
            CyColumn column = table.getColumn(colName);
            if (column == null || column.getType() != Double.class && column.getType() != Integer.class) continue;
            visualizeAttr.add(column.getName());
        }
        ArrayList resultNetAnalyzer = new ArrayList(visualizeAttr);
        ArrayList resultOther = new ArrayList(visualizeAttr);
        resultNetAnalyzer.retainAll(netAnalyzerAttr);
        resultOther.removeAll(netAnalyzerAttr);
        Collections.sort(resultNetAnalyzer);
        Collections.sort(resultOther);
        String[][] result = new String[][]{resultNetAnalyzer.toArray(new String[resultNetAnalyzer.size()]), resultOther.toArray(new String[resultOther.size()])};
        return result;
    }

    public static String[][] getComputedEdgeAttributes(CyNetwork aNetwork) {
        CyTable table = aNetwork.getDefaultEdgeTable();
        Collection columns = table.getColumns();
        Set computedAttr = CyTableUtil.getColumnNames((CyTable)table);
        for (CyEdge n : aNetwork.getEdgeList()) {
            for (CyColumn column : columns) {
                if (aNetwork.getRow((CyIdentifiable)n).isSet(column.getName())) continue;
                computedAttr.remove(column.getName());
            }
        }
        return CyNetworkUtils.keepAvailableAttributes(aNetwork, computedAttr, table, Msgs.getEdgeAttributes());
    }

    public static String[][] getComputedNodeAttributes(CyNetwork aNetwork) {
        CyTable table = aNetwork.getDefaultNodeTable();
        Collection columns = table.getColumns();
        Set computedAttr = CyTableUtil.getColumnNames((CyTable)table);
        for (CyNode n : aNetwork.getNodeList()) {
            for (CyColumn column : columns) {
                if (aNetwork.getRow((CyIdentifiable)n).isSet(column.getName())) continue;
                computedAttr.remove(column.getName());
            }
        }
        return CyNetworkUtils.keepAvailableAttributes(aNetwork, computedAttr, table, Msgs.getNodeAttributes());
    }

    public static Set<CyEdge> getAllConnectingEdges(CyNetwork aNetwork, Collection<CyNode> nodes) {
        HashSet<CyEdge> connEdgeSet = new HashSet<CyEdge>();
        ArrayList<CyNode> nl = new ArrayList<CyNode>(nodes);
        for (int i = 0; i < nl.size(); ++i) {
            for (int j = i + 1; j < nl.size(); ++j) {
                connEdgeSet.addAll(aNetwork.getConnectingEdgeList(nl.get(i), nl.get(j), CyEdge.Type.ANY));
            }
        }
        return connEdgeSet;
    }

    public static int getPairConnCount(CyNetwork aNetwork, Collection<CyNode> aNodeIndices, boolean aIgnoreDir) {
        Set<CyEdge> connEdgeSet = CyNetworkUtils.getAllConnectingEdges(aNetwork, aNodeIndices);
        int edgeCount = connEdgeSet.size();
        ArrayList<CyEdge> connEdges = new ArrayList<CyEdge>(connEdgeSet);
        block0: for (int i = 0; i < connEdges.size(); ++i) {
            CyEdge e = (CyEdge)connEdges.get(i);
            if (e.getSource() == e.getTarget()) {
                --edgeCount;
                continue;
            }
            for (int j = i + 1; j < connEdges.size(); ++j) {
                CyEdge ee = (CyEdge)connEdges.get(j);
                if ((e.getSource() != ee.getSource() || e.getTarget() != ee.getTarget()) && (!aIgnoreDir || e.getSource() != ee.getTarget() || e.getTarget() != ee.getSource())) continue;
                --edgeCount;
                continue block0;
            }
        }
        return edgeCount;
    }

    public static Set<CyNode> getNeighbors(CyNetwork aNetwork, CyNode aNode) {
        return CyNetworkUtils.getNeighbors(aNetwork, aNode, aNetwork.getAdjacentEdgeList(aNode, CyEdge.Type.ANY));
    }

    public static Set<CyNode> getNeighbors(CyNetwork aNetwork, CyNode aNode, List<CyEdge> aIncEdges) {
        HashSet<CyNode> neighborsSet = new HashSet<CyNode>();
        for (CyEdge e : aIncEdges) {
            CyNode sourceNode = e.getSource();
            if (sourceNode != aNode) {
                neighborsSet.add(sourceNode);
                continue;
            }
            CyNode targetNode = e.getTarget();
            if (targetNode == aNode) continue;
            neighborsSet.add(targetNode);
        }
        return neighborsSet;
    }

    public static Map<CyNode, MutInteger> getNeighborMap(CyNetwork aNetwork, CyNode aNode) {
        return CyNetworkUtils.getNeighborMap(aNetwork, aNode, aNetwork.getAdjacentEdgeList(aNode, CyEdge.Type.ANY));
    }

    public static Map<CyNode, MutInteger> getNeighborMap(CyNetwork aNetwork, CyNode aNode, List<CyEdge> aIncEdges) {
        HashMap<CyNode, MutInteger> m = new HashMap<CyNode, MutInteger>();
        for (int i = 0; i < aIncEdges.size(); ++i) {
            CyNode n;
            CyEdge e = aIncEdges.get(i);
            CyNode cyNode = n = e.getSource() == aNode ? e.getTarget() : e.getSource();
            if (n == aNode) continue;
            MutInteger count = (MutInteger)m.get(n);
            if (count == null) {
                m.put(n, new MutInteger(1));
                continue;
            }
            ++count.value;
        }
        return m;
    }

    public static NetworkInspection inspectNetwork(CyNetwork aNetwork) {
        if (aNetwork.getNodeCount() == 0) {
            throw new IllegalArgumentException();
        }
        NetworkInspection insp = new NetworkInspection();
        for (CyEdge edge : aNetwork.getEdgeList()) {
            CyNode source = edge.getSource();
            List connecting = aNetwork.getConnectingEdgeList(edge.getSource(), edge.getTarget(), CyEdge.Type.ANY);
            if (edge.getSource() == edge.getTarget()) {
                int d = 0;
                int u = 0;
                for (CyEdge cei : connecting) {
                    if (cei.isDirected()) {
                        ++d;
                        continue;
                    }
                    ++u;
                }
                if (d > 0) {
                    insp.dirLoops = true;
                    if ((d & 1) != 0) {
                        insp.uniqueDir = true;
                    }
                }
                if (u <= 0) continue;
                insp.undirLoops = true;
                continue;
            }
            int ssd = 0;
            int ttd = 0;
            int std = 0;
            int tsd = 0;
            int ssu = 0;
            int ttu = 0;
            int u = 0;
            for (CyEdge cei : connecting) {
                CyNode ceiSource = cei.getSource();
                CyNode ceiTarget = cei.getTarget();
                boolean directed = cei.isDirected();
                if (ceiSource == source) {
                    if (ceiTarget == source) {
                        if (directed) {
                            ++ssd;
                            continue;
                        }
                        ++ssu;
                        continue;
                    }
                    if (directed) {
                        ++std;
                        continue;
                    }
                    ++u;
                    continue;
                }
                if (ceiTarget == source) {
                    if (directed) {
                        ++tsd;
                        continue;
                    }
                    ++u;
                    continue;
                }
                if (directed) {
                    ++ttd;
                    continue;
                }
                ++ttu;
            }
            if (ssd != 0 || ttd != 0) {
                insp.dirLoops = true;
            }
            if (std != 0 || tsd != 0) {
                insp.dir = true;
            }
            if (ssu != 0 || ttu != 0) {
                insp.undirLoops = true;
            }
            if (u != 0) {
                insp.undir = true;
            }
            if (ssd & true || ttd & true || std != tsd) {
                insp.uniqueDir = true;
            }
            if (std > 1 || tsd > 1) {
                insp.dupEdges = true;
                insp.dupDirEdges = true;
                continue;
            }
            if (std + tsd + u <= 1) continue;
            insp.dupEdges = true;
        }
        insp.stopTimer();
        return insp;
    }

    public static int removeDuplEdges(CyNetwork aNetwork, boolean aIgnoreDir, boolean aCreateEdgeAttr) {
        if (aCreateEdgeAttr) {
            AttributeSetup.createEdgeDuplicateAttribute(aNetwork.getDefaultEdgeTable());
        }
        HashMap<CyNode, Integer> node2id = new HashMap<CyNode, Integer>();
        for (CyNode n : aNetwork.getNodeList()) {
            node2id.put(n, node2id.size());
        }
        HashMap<Long, CyEdge> uniqueEdges = new HashMap<Long, CyEdge>();
        HashMap<Long, Integer> numDuplicates = new HashMap<Long, Integer>();
        ArrayList<CyEdge> forRemoval = new ArrayList<CyEdge>();
        for (CyEdge cyEdge : aNetwork.getEdgeList()) {
            int id2;
            int id1 = (Integer)node2id.get(cyEdge.getSource());
            if (id1 == (id2 = ((Integer)node2id.get(cyEdge.getTarget())).intValue())) continue;
            long edgeId = 0L;
            edgeId = !aIgnoreDir && cyEdge.isDirected() || id1 < id2 ? ((long)id1 << 32) + (long)id2 : ((long)id2 << 32) + (long)id1;
            if (!uniqueEdges.containsKey(edgeId)) {
                uniqueEdges.put(edgeId, cyEdge);
                numDuplicates.put(edgeId, 1);
                continue;
            }
            forRemoval.add(cyEdge);
            numDuplicates.put(edgeId, (Integer)numDuplicates.get(edgeId) + 1);
        }
        aNetwork.removeEdges(forRemoval);
        if (aCreateEdgeAttr) {
            for (Map.Entry entry : uniqueEdges.entrySet()) {
                CyNetworkUtils.saveNumDuplEdges(aNetwork, (CyEdge)entry.getValue(), (Integer)numDuplicates.get(entry.getKey()));
            }
        }
        return forRemoval.size();
    }

    private static void saveNumDuplEdges(CyNetwork net, CyEdge aEdge, int aNumEdges) {
        if (aEdge != null) {
            net.getRow((CyIdentifiable)aEdge).set(Msgs.getAttr("dpe"), (Object)aNumEdges);
        }
    }

    public static int removeSelfLoops(CyNetwork aNetwork) {
        int removedCount = 0;
        ArrayList<CyEdge> toRemove = new ArrayList<CyEdge>();
        for (CyEdge e : aNetwork.getEdgeList()) {
            if (e.getSource() != e.getTarget()) continue;
            toRemove.add(e);
            ++removedCount;
        }
        aNetwork.removeEdges(toRemove);
        return removedCount;
    }
}

