/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicFileChooserUI;

public abstract class Utils {
    public static final int BORDER_SIZE = 6;
    public static final String SEPARATOR = "SEPARATOR";
    public static String DT_FILEEXISTS = "Warning - File Exists";
    public static String SM_FILEEXISTS = "<html>The specified file already exists.<br>Overwrite?";

    public static void adjustWidth(JComponent aComponent, int aWidth) {
        Dimension preferedSize = aComponent.getPreferredSize();
        preferedSize.width = aWidth;
        aComponent.setPreferredSize(preferedSize);
    }

    public static boolean canSave(File aFile, Component aParent) {
        if (aFile.exists()) {
            return JOptionPane.showConfirmDialog(aParent, SM_FILEEXISTS, DT_FILEEXISTS, 0) == 0;
        }
        return true;
    }

    public static JButton createButton(String aText, String aTooltip, ActionListener aListener) {
        JButton button = new JButton(aText);
        button.setToolTipText(aTooltip);
        button.addActionListener(aListener);
        return button;
    }

    public static JButton createButton(Action action, String aTooltip) {
        JButton button = new JButton(action);
        button.setToolTipText(aTooltip);
        return button;
    }

    public static JCheckBox createCheckBox(String aText, String aToolTip, ActionListener aListener) {
        JCheckBox button = new JCheckBox(aText);
        button.setToolTipText(aToolTip);
        button.addActionListener(aListener);
        button.setMaximumSize(new Dimension(Short.MAX_VALUE, button.getHeight()));
        return button;
    }

    public static JLabel createLabel(String aText, String aToolTip) {
        JLabel l = new JLabel(aText);
        l.setToolTipText(aToolTip);
        return l;
    }

    public static String doubleToString(double aValue, int aMaxLength, int aMaxPrecision) {
        return Utils.doubleToString(new Double(aValue), aMaxLength, aMaxPrecision);
    }

    public static String doubleToString(Double aValue, int aMaxLength, int aMaxPrecision) {
        if (aValue.isNaN() || aValue.isInfinite()) {
            return "NaN";
        }
        Object text = aValue.toString();
        int pointIndex = ((String)text).indexOf(46);
        if (pointIndex >= 0 && ((String)text).length() > aMaxLength) {
            if (pointIndex + 1 >= aMaxLength) {
                text = ((String)text).substring(0, pointIndex);
            } else {
                int dap = Math.min(aMaxPrecision, aMaxLength - 1 - pointIndex);
                double v = aValue;
                long rounded = Math.round(v * Math.pow(10.0, dap));
                text = String.valueOf(rounded);
                String sign = rounded < 0L ? "-" : "";
                text = ((String)text).substring(sign.length());
                while (((String)text).length() <= aMaxPrecision) {
                    text = "0" + (String)text;
                }
                text = ((String)(text = sign + (String)text)).length() < aMaxLength ? ((String)text).substring(0, pointIndex) + "." + ((String)text).substring(pointIndex) : ((String)text).substring(0, pointIndex + 1) + "." + ((String)text).substring(pointIndex + 1, aMaxLength - 1);
            }
        }
        return text;
    }

    public static void ensureSize(Dimension aCurrentSize, Dimension aSize) {
        if (aCurrentSize.height < aSize.height) {
            aCurrentSize.height = aSize.height;
        }
        if (aCurrentSize.width < aSize.width) {
            aCurrentSize.width = aSize.width;
        }
    }

    public static void equalizeSize(JButton[] aButtons) {
        Dimension preferredSize = aButtons[0].getPreferredSize();
        Dimension maximumSize = aButtons[0].getMaximumSize();
        for (int i = 1; i < aButtons.length; ++i) {
            Utils.ensureSize(preferredSize, aButtons[i].getPreferredSize());
            Utils.ensureSize(maximumSize, aButtons[i].getMaximumSize());
        }
        Utils.setSizes(aButtons, preferredSize, maximumSize);
    }

    public static void equalizeSize(JButton aButton1, JButton aButton2) {
        Utils.equalizeSize(new JButton[]{aButton1, aButton2});
    }

    public static void equalizeSize(JButton aButton1, JButton aButton2, JButton aButton3) {
        Utils.equalizeSize(new JButton[]{aButton1, aButton2, aButton3});
    }

    public static int getSpinnerInt(JSpinner aSpinner) {
        return ((SpinnerNumberModel)aSpinner.getModel()).getNumber().intValue();
    }

    public static Color invertOf(Color aColor) {
        return new Color(255 - aColor.getRed(), 255 - aColor.getGreen(), 255 - aColor.getBlue());
    }

    public static void removeSelectedFile(JFileChooser aDialog) {
        File file = aDialog.getSelectedFile();
        if (file != null) {
            aDialog.setSelectedFile(null);
            try {
                ((BasicFileChooserUI)aDialog.getUI()).setFileName(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setSizes(JButton[] aButtons, Dimension aPreferred, Dimension aMax) {
        for (JButton button : aButtons) {
            button.setPreferredSize(aPreferred);
            button.setMaximumSize(aMax);
        }
    }

    public static void setStandardBorder(JComponent aComponent) {
        int bs = 6;
        aComponent.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
    }

    public static void showErrorBox(Component aParent, String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(aParent, aMessage, aTitle, 0);
    }

    public static void showInfoBox(Component aParent, String aTitle, String aMessage) {
        JOptionPane.showMessageDialog(aParent, aMessage, aTitle, 1);
    }
}

