/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.analyzer.tasks;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.event.ListSelectionListener;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;

abstract class NetworkListDialog
extends JDialog
implements ListSelectionListener {
    private final CyNetworkManager netMgr;
    protected final Window aOwner;
    protected List<CyNetwork> networks;
    protected JList listNetNames;
    private static final long serialVersionUID = 5706001778102104118L;

    protected NetworkListDialog(Frame aOwner, String aTitle, CyNetworkManager netMgr) {
        super(aOwner, aTitle, true);
        this.aOwner = aOwner;
        this.netMgr = netMgr;
        this.initNetworkList();
    }

    protected NetworkListDialog(Dialog aOwner, String aTitle, CyNetworkManager netMgr) {
        super(aOwner, aTitle, true);
        this.netMgr = netMgr;
        this.aOwner = aOwner;
        this.initNetworkList();
    }

    protected boolean isNetNameSelected() {
        int[] indices = this.listNetNames.getSelectedIndices();
        return indices.length > 0;
    }

    private void initNetworkList() {
        Set networkSet = this.netMgr.getNetworkSet();
        int netCount = networkSet.size();
        this.networks = new ArrayList<CyNetwork>(netCount);
        String[] netTitles = new String[netCount];
        int i = 0;
        for (CyNetwork network : networkSet) {
            this.networks.add(network);
            netTitles[i++] = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        }
        this.listNetNames = new JList<String>(netTitles);
        this.listNetNames.addListSelectionListener(this);
        if (netCount < 8) {
            this.listNetNames.setVisibleRowCount(netCount);
        }
    }
}

