/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.util.Properties;
import org.cytoscape.opencl.cycl.CyCL;
import org.cytoscape.opencl.layout.CLLayout;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.work.undo.UndoSupport;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private final Logger logger = LoggerFactory.getLogger(CyActivator.class);

    public void start(BundleContext bc) {
        this.registerServiceListener(bc, (cycl, props) -> this.initialize(bc, (CyCL)cycl), (cycl, props) -> {}, CyCL.class);
    }

    private void initialize(BundleContext bc, CyCL cycl) {
        new Thread(() -> {
            try {
                if (CyCL.getDevices().size() == 0) {
                    this.logger.error("No OpenCL compatible device found. Cannot register 'Prefuse Force Directed OpenCL Layout'.");
                    return;
                }
                UndoSupport undo = (UndoSupport)this.getService(bc, UndoSupport.class);
                CLLayout forceDirectedCLLayout = new CLLayout(undo);
                Properties forceDirectedCLLayoutProps = new Properties();
                forceDirectedCLLayoutProps.setProperty("preferredMenu", "Layout.Cytoscape Layouts");
                forceDirectedCLLayoutProps.setProperty("preferredTaskManager", "menu");
                forceDirectedCLLayoutProps.setProperty("title", forceDirectedCLLayout.toString());
                forceDirectedCLLayoutProps.setProperty("menuGravity", "10.5");
                this.registerService(bc, (Object)forceDirectedCLLayout, CyLayoutAlgorithm.class, forceDirectedCLLayoutProps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }
}

