/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.util.List;
import java.util.Random;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.opencl.cycl.CyCL;
import org.cytoscape.opencl.cycl.CyCLBuffer;
import org.cytoscape.opencl.cycl.CyCLDevice;
import org.cytoscape.opencl.cycl.CyCLLocalSize;
import org.cytoscape.opencl.cycl.CyCLProgram;
import org.cytoscape.opencl.layout.CLLayoutContext;
import org.cytoscape.opencl.layout.SlimNetwork;
import org.cytoscape.view.layout.AbstractParallelPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;

public class CLLayoutTask
extends AbstractParallelPartitionLayoutTask {
    private volatile Object sync = new Object();
    private final CLLayoutContext context;
    private final CyCLDevice device;
    private final CyCLProgram program;

    public CLLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, CLLayoutContext context, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        CyCLProgram tryProgram;
        this.context = context;
        this.edgeWeighter = context.edgeWeighter;
        this.edgeWeighter.setWeightAttribute(this.layoutAttribute);
        try {
            this.device = (CyCLDevice)CyCL.getDevices().get(0);
        }
        catch (Exception e) {
            System.out.println("No OpenCL devices found, cannot do layout.");
            throw new RuntimeException();
        }
        String[] kernelNames = new String[]{"Init", "CalcForcesGravity", "PrepareEdgeRepulsion", "CalcForcesEdgeRepulsion", "CalcForcesSpringDrag", "IntegrateRK0", "IntegrateRK1", "IntegrateRK2", "IntegrateRK3", "IntegrateEuler"};
        try {
            tryProgram = this.device.addProgram("PrefuseLayout", ((Object)((Object)this)).getClass().getResource("/LayoutKernels.cl"), kernelNames, null, false);
        }
        catch (Exception exc) {
            System.out.println("Could not load and compile OpenCL program, cannot do layout.");
            throw new RuntimeException();
        }
        this.program = tryProgram;
    }

    public void layoutPartition(LayoutPartition partition) {
        Layouter layouter = new Layouter();
        layouter.doLayout(partition);
    }

    public String toString() {
        return "Prefuse Force Directed OpenCL Layout";
    }

    private class Layouter {
        public static final int requiredPadding = 16;
        private CyCLBuffer bufferNodePosX;
        private CyCLBuffer bufferNodePosY;
        private CyCLBuffer bufferNodeMass;
        private CyCLBuffer bufferEdges;
        private CyCLBuffer bufferEdgeCoeffs;
        private CyCLBuffer bufferEdgeLengths;
        private CyCLBuffer bufferEdgeOffsets;
        private CyCLBuffer bufferEdgeCounts;
        private CyCLBuffer bufferEdgeUniqueSources;
        private CyCLBuffer bufferEdgeUniqueTargets;
        private CyCLBuffer bufferEdgeStartX;
        private CyCLBuffer bufferEdgeStartY;
        private CyCLBuffer bufferEdgeTangentX;
        private CyCLBuffer bufferEdgeTangentY;
        private CyCLBuffer bufferEdgeCurrentLength;
        private CyCLBuffer bufferEdgeMassStart;
        private CyCLBuffer bufferEdgeMassEnd;
        private CyCLBuffer bufferForce;
        private CyCLBuffer bufferVelocity;
        private CyCLBuffer bufferNodeK;
        private CyCLBuffer bufferNodeL;
        private boolean buffersInitialized = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLayout(LayoutPartition part) {
            Object object = CLLayoutTask.this.sync;
            synchronized (object) {
                int i;
                long startTime = System.currentTimeMillis();
                if (CLLayoutTask.this.context.fromScratch) {
                    Random rand = new Random(123L);
                    List nodeList = part.getNodeList();
                    for (LayoutNode node : nodeList) {
                        node.setX((double)((rand.nextFloat() - 0.5f) * 2.0f));
                        node.setY((double)((rand.nextFloat() - 0.5f) * 2.0f));
                    }
                }
                part.calculateEdgeWeights();
                SlimNetwork slim = new SlimNetwork(part, CLLayoutTask.this.context.isDeterministic, (float)CLLayoutTask.this.context.defaultNodeMass, (float)CLLayoutTask.this.context.defaultSpringCoefficient, (float)CLLayoutTask.this.context.defaultSpringLength, CLLayoutTask.this.edgeWeighter, 16);
                this.initializeBuffers(slim);
                if (CLLayoutTask.this.taskMonitor != null) {
                    CLLayoutTask.this.taskMonitor.setStatusMessage("Moving partition " + part.getPartitionNumber());
                }
                this.initializeSimulation(slim);
                float timestep = 1000.0f;
                for (i = 0; i < CLLayoutTask.this.context.numIterations && !CLLayoutTask.this.cancelled; ++i) {
                    float decrease = 1.0f - (float)i / (float)CLLayoutTask.this.context.numIterations;
                    float step = (timestep *= decrease) + 50.0f;
                    this.advanceSimulation(step, false, slim);
                }
                if (CLLayoutTask.this.context.numIterationsEdgeRepulsive > 0) {
                    this.initializeSimulation(slim);
                    timestep = 10.0f;
                    for (i = 0; i < CLLayoutTask.this.context.numIterationsEdgeRepulsive && !CLLayoutTask.this.cancelled; ++i) {
                        float decrease = 1.0f - (float)i / (float)CLLayoutTask.this.context.numIterations;
                        timestep *= decrease;
                        this.advanceSimulation(0.25f, true, slim);
                    }
                }
                this.getPositions(slim);
                long stopTime = System.currentTimeMillis();
                part.resetNodes();
                for (LayoutNode ln : part.getNodeList()) {
                    if (ln.isLocked()) continue;
                    int id = slim.nodeToIndex.get(ln);
                    ln.setX((double)slim.nodePosX[id]);
                    ln.setY((double)slim.nodePosY[id]);
                    part.moveNodeToLocation(ln);
                }
                this.freeBuffers();
            }
        }

        private void initializeBuffers(SlimNetwork slim) {
            this.bufferNodePosX = CLLayoutTask.this.device.createBuffer(slim.nodePosX);
            this.bufferNodePosY = CLLayoutTask.this.device.createBuffer(slim.nodePosY);
            this.bufferNodeMass = CLLayoutTask.this.device.createBuffer(slim.nodeMass);
            this.bufferEdges = CLLayoutTask.this.device.createBuffer(slim.edges);
            this.bufferEdgeCoeffs = CLLayoutTask.this.device.createBuffer(slim.edgeCoeffs);
            this.bufferEdgeLengths = CLLayoutTask.this.device.createBuffer(slim.edgeLengths);
            this.bufferEdgeOffsets = CLLayoutTask.this.device.createBuffer(slim.edgeOffsetsSparse);
            this.bufferEdgeCounts = CLLayoutTask.this.device.createBuffer(slim.edgeCounts);
            if (CLLayoutTask.this.context.numIterationsEdgeRepulsive > 0) {
                this.bufferEdgeUniqueSources = CLLayoutTask.this.device.createBuffer(slim.edgeUniqueSources);
                this.bufferEdgeUniqueTargets = CLLayoutTask.this.device.createBuffer(slim.edgeUniqueTargets);
                this.bufferEdgeStartX = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeStartY = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeTangentX = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeTangentY = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeCurrentLength = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeMassStart = CLLayoutTask.this.device.createBuffer(slim.edgeMassStart);
                this.bufferEdgeMassEnd = CLLayoutTask.this.device.createBuffer(slim.edgeMassEnd);
            }
            this.bufferForce = CLLayoutTask.this.device.createBuffer(Float.TYPE, slim.numNodesPadded * 2);
            this.bufferVelocity = CLLayoutTask.this.device.createBuffer(Float.TYPE, slim.numNodes * 2);
            this.bufferNodeK = CLLayoutTask.this.device.createBuffer(Float.TYPE, slim.numNodes * 8);
            this.bufferNodeL = CLLayoutTask.this.device.createBuffer(Float.TYPE, slim.numNodes * 6);
            this.buffersInitialized = true;
        }

        private void freeBuffers() {
            if (!this.buffersInitialized) {
                return;
            }
            this.bufferNodePosX.free();
            this.bufferNodePosY.free();
            this.bufferNodeMass.free();
            this.bufferEdges.free();
            this.bufferEdgeCoeffs.free();
            this.bufferEdgeLengths.free();
            this.bufferEdgeOffsets.free();
            this.bufferEdgeCounts.free();
            if (CLLayoutTask.this.context.numIterationsEdgeRepulsive > 0) {
                this.bufferEdgeStartX.free();
                this.bufferEdgeStartY.free();
                this.bufferEdgeStartX.free();
                this.bufferEdgeStartY.free();
                this.bufferEdgeTangentX.free();
                this.bufferEdgeTangentY.free();
                this.bufferEdgeCurrentLength.free();
                this.bufferEdgeMassStart.free();
                this.bufferEdgeMassEnd.free();
            }
            this.bufferForce.free();
            this.bufferVelocity.free();
            this.bufferNodeK.free();
            this.bufferNodeL.free();
            this.buffersInitialized = false;
        }

        private void initializeSimulation(SlimNetwork slim) {
            CLLayoutTask.this.program.getKernel("Init").execute(new long[]{slim.numNodes}, null, new Object[]{this.bufferVelocity, slim.numNodes});
        }

        private void getPositions(SlimNetwork slim) {
            this.bufferNodePosX.getFromDevice(slim.nodePosX);
            this.bufferNodePosY.getFromDevice(slim.nodePosY);
        }

        private void advanceSimulation(float timestep, boolean doEdgeRepulsion, SlimNetwork slim) {
            long[] dimsLocal = new long[]{CLLayoutTask.this.device.bestBlockSize};
            long[] dimsGlobal = new long[]{this.nextMultipleOf(slim.numNodes, dimsLocal[0])};
            this.calculateForces(doEdgeRepulsion, slim);
            CLLayoutTask.this.program.getKernel("IntegrateRK0").execute(dimsGlobal, dimsLocal, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferNodeK, this.bufferNodeL, this.bufferVelocity, this.bufferForce, Float.valueOf(timestep), slim.numNodes});
            this.calculateForces(doEdgeRepulsion, slim);
            CLLayoutTask.this.program.getKernel("IntegrateRK1").execute(dimsGlobal, dimsLocal, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferNodeK, this.bufferNodeL, this.bufferVelocity, this.bufferForce, Float.valueOf(1.0f), Float.valueOf(timestep), slim.numNodes});
            this.calculateForces(doEdgeRepulsion, slim);
            CLLayoutTask.this.program.getKernel("IntegrateRK2").execute(dimsGlobal, dimsLocal, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferNodeK, this.bufferNodeL, this.bufferVelocity, this.bufferForce, Float.valueOf(1.0f), Float.valueOf(timestep), slim.numNodes});
            this.calculateForces(doEdgeRepulsion, slim);
            CLLayoutTask.this.program.getKernel("IntegrateRK3").execute(dimsGlobal, dimsLocal, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferNodeK, this.bufferNodeL, this.bufferVelocity, this.bufferForce, Float.valueOf(1.0f), Float.valueOf(timestep), slim.numNodes});
        }

        private void calculateForces(boolean doEdgeRepulsion, SlimNetwork slim) {
            long[] lArray;
            long[] lArray2;
            long[] dimsLocalEdgeRepulsion = new long[]{CLLayoutTask.this.device.bestBlockSize};
            long[] dimsGlobalEdgeRepulsion = new long[]{Math.min(65536L, this.nextMultipleOf(slim.numEdgesUnique, dimsLocalEdgeRepulsion[0]))};
            long[] dimsLocalGravity = new long[]{CLLayoutTask.this.device.bestBlockSize};
            long[] dimsGlobalGravity = new long[]{CLLayoutTask.this.device.type == CyCLDevice.DeviceTypes.GPU ? this.nextMultipleOf(slim.numNodes, dimsLocalGravity[0]) : (long)(slim.numNodesPadded / 2)};
            if (CLLayoutTask.this.device.type == CyCLDevice.DeviceTypes.GPU) {
                long[] lArray3 = new long[2];
                lArray3[0] = 16L;
                lArray2 = lArray3;
                lArray3[1] = CLLayoutTask.this.device.bestBlockSize / 16L;
            } else {
                long[] lArray4 = new long[1];
                lArray2 = lArray4;
                lArray4[0] = 1L;
            }
            long[] dimsLocalSpring = lArray2;
            if (CLLayoutTask.this.device.type == CyCLDevice.DeviceTypes.GPU) {
                long[] lArray5 = new long[2];
                lArray5[0] = 16L;
                lArray = lArray5;
                lArray5[1] = this.nextMultipleOf(slim.numNodes, dimsLocalSpring[1]);
            } else {
                long[] lArray6 = new long[1];
                lArray = lArray6;
                lArray6[0] = slim.numNodes;
            }
            long[] dimsGlobalSpring = lArray;
            if (CLLayoutTask.this.device.type == CyCLDevice.DeviceTypes.GPU) {
                CLLayoutTask.this.program.getKernel("CalcForcesGravity").execute(dimsGlobalGravity, dimsLocalGravity, new Object[]{new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferForce, slim.numNodes, slim.numNodesPadded});
            } else {
                CLLayoutTask.this.program.getKernel("CalcForcesGravity").execute(dimsGlobalGravity, dimsLocalGravity, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferForce, slim.numNodesPadded / 2});
            }
            if (doEdgeRepulsion) {
                CLLayoutTask.this.program.getKernel("PrepareEdgeRepulsion").execute(dimsGlobalEdgeRepulsion, dimsLocalEdgeRepulsion, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferEdgeUniqueSources, this.bufferEdgeUniqueTargets, this.bufferEdgeStartX, this.bufferEdgeStartY, this.bufferEdgeTangentX, this.bufferEdgeTangentY, this.bufferEdgeCurrentLength, slim.numEdgesUnique});
                CLLayoutTask.this.program.getKernel("CalcForcesEdgeRepulsion").execute(dimsGlobalGravity, dimsLocalGravity, new Object[]{new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), new CyCLLocalSize(Long.valueOf(dimsLocalGravity[0] * 4L)), this.bufferNodePosX, this.bufferNodePosY, this.bufferNodeMass, this.bufferEdgeStartX, this.bufferEdgeStartY, this.bufferEdgeTangentX, this.bufferEdgeTangentY, this.bufferEdgeCurrentLength, this.bufferEdgeMassStart, this.bufferEdgeMassEnd, this.bufferForce, slim.numNodes, slim.numEdgesUniquePadded});
            }
            if (CLLayoutTask.this.device.type == CyCLDevice.DeviceTypes.GPU) {
                CLLayoutTask.this.program.getKernel("CalcForcesSpringDrag").execute(dimsGlobalSpring, dimsLocalSpring, new Object[]{new CyCLLocalSize(Long.valueOf(dimsLocalSpring[0] * dimsLocalSpring[1] * 2L * 4L)), this.bufferNodePosX, this.bufferNodePosY, this.bufferEdges, this.bufferEdgeOffsets, this.bufferEdgeCounts, this.bufferEdgeCoeffs, this.bufferEdgeLengths, this.bufferVelocity, this.bufferForce, slim.numNodes});
            } else {
                CLLayoutTask.this.program.getKernel("CalcForcesSpringDrag").execute(dimsGlobalSpring, dimsLocalSpring, new Object[]{this.bufferNodePosX, this.bufferNodePosY, this.bufferEdges, this.bufferEdgeOffsets, this.bufferEdgeCounts, this.bufferEdgeCoeffs, this.bufferEdgeLengths, this.bufferVelocity, this.bufferForce, slim.numNodes});
            }
        }

        private long nextMultipleOf(long n, long multipleOf) {
            return (n + multipleOf - 1L) / multipleOf * multipleOf;
        }
    }
}

