/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.websession;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.write.json.CytoscapeJsNetworkWriterFactory;
import org.cytoscape.io.internal.write.websession.WebSessionWriterImpl;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskMonitor;

public class ZippedArchiveWriter
extends WebSessionWriterImpl {
    private static final String ZIP_FOLDER = "networks";
    private VisualMappingManager vmm;

    public ZippedArchiveWriter(OutputStream outputStream, String exportType, VizmapWriterFactory jsonStyleWriterFactory, VisualMappingManager vmm, CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory, CyNetworkViewManager viewManager, CyApplicationConfiguration appConfig, CyApplicationManager applicationManager) {
        super(outputStream, exportType, jsonStyleWriterFactory, vmm, cytoscapejsWriterFactory, viewManager, appConfig);
        this.vmm = vmm;
    }

    @Override
    public void writeFiles(TaskMonitor tm) throws Exception {
        tm.setProgress(0.1);
        tm.setStatusMessage("Saving networks as Cytoscape.js javascript...");
        Set viewSet = this.viewManager.getNetworkViewSet();
        File networkFile = this.createNetworkViewFile(viewSet);
        ArrayList<File> files = new ArrayList<File>();
        files.add(networkFile);
        tm.setProgress(0.7);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving Visual Styles as javascript...");
        ArrayList<VisualStyle> styles = new ArrayList<VisualStyle>();
        styles.add(this.vmm.getCurrentVisualStyle());
        for (VisualStyle vs : this.vmm.getAllVisualStyles()) {
            if (vs == styles.get(0)) continue;
            styles.add(vs);
        }
        File styleFile = this.createStyleFile(tm, new HashSet<VisualStyle>(styles));
        files.add(styleFile);
        tm.setProgress(0.9);
        this.zipAll(files);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Done.");
        tm.setProgress(1.0);
    }

    private final void zipAll(Collection<File> files) throws IOException {
        this.zos = new ZipOutputStream(this.outputStream);
        this.addFiles(files, this.zos);
        this.zos.close();
    }

    private void addFiles(Collection<File> files, ZipOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        for (File file : files) {
            int len;
            if (file.isDirectory()) continue;
            FileInputStream in = new FileInputStream(file);
            String zipFilePath = null;
            String fileName = file.getName();
            Path dataFilePath = Paths.get(ZIP_FOLDER, fileName);
            zipFilePath = dataFilePath.toString();
            if (File.separatorChar != '/') {
                zipFilePath = zipFilePath.replace('\\', '/');
            }
            if (zipFilePath.contains("style_")) {
                zipFilePath = "styles.js";
            } else if (zipFilePath.contains("networks_")) {
                zipFilePath = "networks.js";
            }
            ZipEntry entry = new ZipEntry(zipFilePath);
            out.putNextEntry(entry);
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }
}

