/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.websession;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.io.internal.write.json.CytoscapeJsNetworkWriterFactory;
import org.cytoscape.io.internal.write.json.JSONNetworkViewWriter;
import org.cytoscape.io.internal.write.websession.WebSessionWriter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSessionWriterImpl
extends AbstractTask
implements CyWriter,
WebSessionWriter {
    private static final Logger logger = LoggerFactory.getLogger(WebSessionWriterImpl.class);
    protected static final String FOLDER_NAME = "web_session";
    protected static final String WEB_RESOURCE_NAME = "web";
    private static final String JS_EXT = ".js";
    protected File webResourceDirectory;
    protected ZipOutputStream zos;
    private TaskMonitor taskMonitor;
    protected final OutputStream outputStream;
    private final VizmapWriterFactory jsonStyleWriterFactory;
    private final VisualMappingManager vmm;
    private final CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory;
    protected final CyNetworkViewManager viewManager;
    protected final String exportType;
    private final Path absResourcePath;

    public WebSessionWriterImpl(OutputStream outputStream, String exportType, VizmapWriterFactory jsonStyleWriterFactory, VisualMappingManager vmm, CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory, CyNetworkViewManager viewManager, CyApplicationConfiguration appConfig) {
        this.outputStream = outputStream;
        this.jsonStyleWriterFactory = jsonStyleWriterFactory;
        this.vmm = vmm;
        this.cytoscapejsWriterFactory = cytoscapejsWriterFactory;
        this.viewManager = viewManager;
        this.webResourceDirectory = appConfig.getConfigurationDirectoryLocation();
        this.exportType = exportType;
        File resourceDir = new File(WEB_RESOURCE_NAME, exportType);
        File resourceDirectoryFile = new File(this.webResourceDirectory.getAbsolutePath(), resourceDir.getPath());
        this.absResourcePath = Paths.get(resourceDirectoryFile.getAbsolutePath(), new String[0]);
    }

    public void run(TaskMonitor tm) throws Exception {
        this.taskMonitor = tm;
        try {
            tm.setProgress(0.1);
            tm.setTitle("Archiving into zip files");
            this.zos = new ZipOutputStream(this.outputStream);
            this.writeFiles(tm);
        }
        finally {
            try {
                if (this.zos != null) {
                    this.zos.close();
                    this.zos = null;
                }
            }
            catch (Exception e) {
                logger.error("Error closing zip output stream", (Throwable)e);
            }
        }
    }

    @Override
    public void writeFiles(TaskMonitor tm) throws Exception {
        tm.setProgress(0.1);
        tm.setStatusMessage("Saving networks as Cytoscape.js javascript...");
        Set netViews = this.viewManager.getNetworkViewSet();
        File networkFile = this.createNetworkViewFile(netViews);
        tm.setProgress(0.7);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving Visual Styles as javascript...");
        ArrayList<VisualStyle> styles = new ArrayList<VisualStyle>();
        styles.add(this.vmm.getCurrentVisualStyle());
        for (VisualStyle vs : this.vmm.getAllVisualStyles()) {
            if (vs == styles.get(0)) continue;
            styles.add(vs);
        }
        File styleFile = this.createStyleFile(tm, new HashSet<VisualStyle>(styles));
        tm.setProgress(0.9);
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.add(networkFile);
        fileList.add(styleFile);
        Path resourceFilePath = Paths.get(this.webResourceDirectory.getAbsolutePath(), WEB_RESOURCE_NAME, this.exportType);
        fileList.add(resourceFilePath.toFile());
        this.zipAll(fileList);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Done.");
        tm.setProgress(1.0);
    }

    private final void zipAll(Collection<File> files) throws IOException {
        this.zos = new ZipOutputStream(this.outputStream);
        this.addDir(files.toArray(new File[0]), this.zos);
        this.zos.close();
    }

    private void addDir(File[] files, ZipOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        for (File file : files) {
            int len;
            if (file.isDirectory()) {
                this.addDir(file.listFiles(), out);
                continue;
            }
            Path filePath = file.toPath();
            FileInputStream in = new FileInputStream(file);
            String zipFilePath = null;
            if (!filePath.getParent().toString().contains(this.absResourcePath.toString())) {
                String name = file.getName().startsWith("style_") ? "styles.js" : "networks.js";
                Path dataFilePath = Paths.get(FOLDER_NAME, "data", name);
                zipFilePath = dataFilePath.toString();
            } else {
                Path relPath = this.absResourcePath.relativize(filePath);
                Path newResourceFilePath = Paths.get(FOLDER_NAME, relPath.toString());
                zipFilePath = newResourceFilePath.toString();
            }
            if (File.separatorChar != '/') {
                zipFilePath = zipFilePath.replace('\\', '/');
            }
            ZipEntry entry = new ZipEntry(zipFilePath);
            out.putNextEntry(entry);
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }

    protected final File createStyleFile(TaskMonitor tm, Set<VisualStyle> styles) throws Exception {
        File styleFile = File.createTempFile("style_", JS_EXT);
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        CyWriter vizmapWriter = this.jsonStyleWriterFactory.createWriter((OutputStream)bStream, styles);
        vizmapWriter.run(tm);
        FileOutputStream stream = new FileOutputStream(styleFile);
        stream.write("var styles = ".getBytes());
        stream.write(bStream.toByteArray());
        stream.close();
        vizmapWriter.run(this.taskMonitor);
        return styleFile;
    }

    protected File createNetworkViewFile(Collection<CyNetworkView> netViews) throws Exception {
        if (netViews.isEmpty()) {
            throw new IllegalArgumentException("No network view.");
        }
        File networkFile = File.createTempFile("networks_", JS_EXT);
        FileOutputStream stream = new FileOutputStream(networkFile);
        stream.write("var networks = {".getBytes());
        int len = 0;
        for (CyNetworkView view : netViews) {
            if (this.cancelled) {
                stream.close();
                return networkFile;
            }
            CyNetwork network = (CyNetwork)view.getModel();
            String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            JSONNetworkViewWriter writer = (JSONNetworkViewWriter)this.cytoscapejsWriterFactory.createWriter((OutputStream)bStream, view);
            writer.run(this.taskMonitor);
            stream.write(String.format("\"%s\": %s", networkName, bStream.toString()).getBytes());
            if (++len >= netViews.size()) continue;
            stream.write(44);
        }
        stream.write(125);
        stream.close();
        return networkFile;
    }
}

