/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.websession;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.internal.write.json.CytoscapeJsNetworkWriterFactory;
import org.cytoscape.io.internal.write.websession.SimpleWebSessionWriterImpl;
import org.cytoscape.io.internal.write.websession.WebSessionWriterImpl;
import org.cytoscape.io.internal.write.websession.ZippedArchiveWriter;
import org.cytoscape.io.write.CySessionWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;

public class WebSessionWriterFactoryImpl
implements CyWriterFactory,
CySessionWriterFactory {
    private static final String DEF_WEB_RESOURCE = "web.zip";
    private static final String WEB_RESOURCE_DIR_NAME = "web";
    private static final String VERSION_FILE = "webSession-v0.2.0.txt";
    public static final String FULL_EXPORT = "full";
    public static final String SIMPLE_EXPORT = "simple";
    public static final String ZIP_EXPORT = "zip";
    private static final int BUFFER_SIZE = 4096;
    private final CyFileFilter filter;
    private final VizmapWriterFactory jsonStyleWriterFactory;
    private final VisualMappingManager vmm;
    private final CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory;
    private final CyNetworkViewManager viewManager;
    private final CyApplicationConfiguration appConfig;
    private final CyApplicationManager cyApplicationManager;
    private final String exportType;

    public WebSessionWriterFactoryImpl(VizmapWriterFactory jsonStyleWriterFactory, VisualMappingManager vmm, CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory, CyNetworkViewManager viewManager, CyFileFilter filter, CyApplicationConfiguration appConfig, CyApplicationManager cyApplicationManager, String exportType) {
        this.jsonStyleWriterFactory = jsonStyleWriterFactory;
        this.vmm = vmm;
        this.cytoscapejsWriterFactory = cytoscapejsWriterFactory;
        this.viewManager = viewManager;
        this.filter = filter;
        this.appConfig = appConfig;
        this.exportType = exportType;
        this.cyApplicationManager = cyApplicationManager;
        try {
            this.extractDefault();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create web resource files.", e);
        }
    }

    private boolean isUpToDate(File f) {
        File version = new File(f, VERSION_FILE);
        return version.exists();
    }

    private final void extractDefault() throws IOException {
        URL source = this.getClass().getClassLoader().getResource(DEF_WEB_RESOURCE);
        File configLocation = this.appConfig.getConfigurationDirectoryLocation();
        File webResource = new File(configLocation, WEB_RESOURCE_DIR_NAME);
        if (!(webResource.exists() && webResource.isDirectory() && this.isUpToDate(webResource))) {
            this.extractResources(source, configLocation);
            new File(webResource, VERSION_FILE).createNewFile();
        }
    }

    public void extractResources(URL source, File destDir) throws IOException {
        destDir.mkdir();
        ZipInputStream zipIn = new ZipInputStream(source.openStream());
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDir.getPath() + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.unzipFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private final void unzipFile(ZipInputStream zis, String filePath) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        int read = 0;
        while ((read = zis.read(buffer)) != -1) {
            bos.write(buffer, 0, read);
        }
        bos.close();
    }

    public CyWriter createWriter(OutputStream outputStream, CySession session) {
        if (this.exportType.equals(FULL_EXPORT)) {
            return new WebSessionWriterImpl(outputStream, this.exportType, this.jsonStyleWriterFactory, this.vmm, this.cytoscapejsWriterFactory, this.viewManager, this.appConfig);
        }
        if (this.exportType.equals(SIMPLE_EXPORT)) {
            return new SimpleWebSessionWriterImpl(outputStream, this.exportType, this.jsonStyleWriterFactory, this.vmm, this.cytoscapejsWriterFactory, this.viewManager, this.appConfig, this.cyApplicationManager);
        }
        if (this.exportType.equals(ZIP_EXPORT)) {
            return new ZippedArchiveWriter(outputStream, this.exportType, this.jsonStyleWriterFactory, this.vmm, this.cytoscapejsWriterFactory, this.viewManager, this.appConfig, this.cyApplicationManager);
        }
        throw new IllegalArgumentException("Invalid export type.");
    }

    public CyFileFilter getFileFilter() {
        return this.filter;
    }
}

