/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;

public class CytoscapejsMapper {
    private Map<CyNode, Double[]> positionMap;

    public CyNetwork createNetwork(JsonNode rootNode, CyNetwork network, String collectionName) {
        JsonNode columnTypes = rootNode.get(CytoscapeJsToken.COLUMN_TYPES.getTag());
        if (columnTypes != null) {
            this.parseColumnTypes(columnTypes, network);
        }
        JsonNode elements = rootNode.get(CytoscapeJsToken.ELEMENTS.getTag());
        JsonNode nodes = elements.get(CytoscapeJsToken.NODES.getTag());
        JsonNode edges = elements.get(CytoscapeJsToken.EDGES.getTag());
        JsonNode data = rootNode.get(CytoscapeJsToken.DATA.getTag());
        if (data != null) {
            this.addTableData(data, (CyIdentifiable)network, network, network.getTable(CyNetwork.class, "LOCAL_ATTRS"));
        }
        this.positionMap = new HashMap<CyNode, Double[]>();
        Map<String, CyNode> nodeMap = this.addNodes(network, nodes);
        this.addEdges(network, edges, nodeMap);
        if (collectionName != null) {
            CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("name", (Object)collectionName);
        }
        return network;
    }

    public CyNetwork createNetworkFromElementList(JsonNode rootNode, CyNetwork network, String collectionName) {
        if (!rootNode.isArray()) {
            throw new IllegalArgumentException("Element list should be an JSON array.");
        }
        JsonNode elements = rootNode;
        ArrayNode nodes = new ArrayNode(new JsonNodeFactory(false));
        ArrayNode edges = new ArrayNode(new JsonNodeFactory(false));
        StreamSupport.stream(elements.spliterator(), false).forEach(element -> this.addElement(nodes, edges, (JsonNode)element));
        this.positionMap = new HashMap<CyNode, Double[]>();
        Map<String, CyNode> nodeMap = this.addNodes(network, (JsonNode)nodes);
        this.addEdges(network, (JsonNode)edges, nodeMap);
        if (collectionName != null) {
            CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("name", (Object)collectionName);
        }
        return network;
    }

    private final void addElement(ArrayNode nodes, ArrayNode edges, JsonNode node) {
        JsonNode group = node.get("group");
        if (group == null) {
            return;
        }
        String elementType = group.textValue();
        if (elementType == null) {
            return;
        }
        if (elementType.equals("nodes")) {
            nodes.add(node);
        } else if (elementType.equals("edges")) {
            edges.add(node);
        }
    }

    private final void parseColumnTypes(JsonNode columnTypes, CyNetwork network) {
        JsonNode net;
        JsonNode edge;
        JsonNode node = columnTypes.get(CytoscapeJsToken.NODE.getTag());
        if (node != null) {
            this.parseType(node, network.getDefaultNodeTable());
        }
        if ((edge = columnTypes.get(CytoscapeJsToken.EDGE.getTag())) != null) {
            this.parseType(edge, network.getDefaultEdgeTable());
        }
        if ((net = columnTypes.get(CytoscapeJsToken.NETWORK.getTag())) != null) {
            this.parseType(net, network.getTable(CyNetwork.class, "LOCAL_ATTRS"));
        }
    }

    private final void parseType(JsonNode typeArray, CyTable table) {
        for (JsonNode entry : typeArray) {
            JsonNode columnName = entry.get(CytoscapeJsToken.COLUMN_NAME.getTag());
            JsonNode type = entry.get(CytoscapeJsToken.TYPE.getTag());
            String name = columnName.textValue();
            CyColumn column = table.getColumn(name);
            if (column != null) continue;
            String typeString = type.textValue();
            Class<?> dataType = this.getType(typeString);
            if (dataType == List.class) {
                JsonNode listClass = entry.get(CytoscapeJsToken.LIST_TYPE.getTag());
                Class<?> listType = this.getType(listClass.textValue());
                table.createListColumn(name, listType, false);
                continue;
            }
            table.createColumn(name, dataType, false);
        }
    }

    private final Class<?> getType(String type) {
        if (type.equals(List.class.getSimpleName())) {
            return List.class;
        }
        if (type.equals(Double.class.getSimpleName())) {
            return Double.class;
        }
        if (type.equals(Integer.class.getSimpleName())) {
            return Integer.class;
        }
        if (type.equals(Long.class.getSimpleName())) {
            return Long.class;
        }
        if (type.equals(Boolean.class.getSimpleName())) {
            return Boolean.class;
        }
        return String.class;
    }

    private final Map<String, CyNode> addNodes(CyNetwork network, JsonNode nodes) {
        HashMap<String, CyNode> nodeMap = new HashMap<String, CyNode>();
        CyTable nodeTable = network.getDefaultNodeTable();
        for (JsonNode node : nodes) {
            JsonNode position;
            JsonNode data = node.get(CytoscapeJsToken.DATA.getTag());
            JsonNode nodeId = data.get(CytoscapeJsToken.ID.getTag());
            CyNode cyNode = (CyNode)nodeMap.get(nodeId.textValue());
            if (cyNode == null) {
                cyNode = network.addNode();
                network.getRow((CyIdentifiable)cyNode).set("name", (Object)nodeId.textValue());
                nodeMap.put(nodeId.textValue(), cyNode);
                this.addTableData(data, (CyIdentifiable)cyNode, network, nodeTable);
            }
            if ((position = node.get(CytoscapeJsToken.POSITION.getTag())) == null) continue;
            JsonNode x = position.get(CytoscapeJsToken.POSITION_X.getTag());
            JsonNode y = position.get(CytoscapeJsToken.POSITION_Y.getTag());
            Double[] positionArray = new Double[]{x.doubleValue(), y.doubleValue()};
            this.positionMap.put(cyNode, positionArray);
        }
        return nodeMap;
    }

    private final void addEdges(CyNetwork network, JsonNode edges, Map<String, CyNode> nodeMap) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        for (JsonNode edge : edges) {
            JsonNode data = edge.get(CytoscapeJsToken.DATA.getTag());
            JsonNode source = data.get(CytoscapeJsToken.SOURCE.getTag());
            JsonNode target = data.get(CytoscapeJsToken.TARGET.getTag());
            CyNode sourceNode = nodeMap.get(source.textValue());
            CyNode targetNode = nodeMap.get(target.textValue());
            CyEdge newEdge = network.addEdge(sourceNode, targetNode, true);
            this.addTableData(data, (CyIdentifiable)newEdge, network, edgeTable);
        }
    }

    private final void addTableData(JsonNode data, CyIdentifiable graphObject, CyNetwork network, CyTable table) {
        Iterator fieldNames = data.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (fieldName.equals("SUID") || fieldName.equals("selected")) continue;
            if (table.getColumn(fieldName) == null) {
                Class<?> dataType = this.getDataType(data.get(fieldName));
                if (dataType == List.class) {
                    Class<?> listDataType = this.getListDataType(data.get(fieldName));
                    table.createListColumn(fieldName, listDataType, false);
                } else {
                    table.createColumn(fieldName, dataType, false);
                }
            }
            CyColumn col = table.getColumn(fieldName);
            network.getRow(graphObject).set(fieldName, this.getValue(data.get(fieldName), col));
        }
    }

    private final Class<?> getListDataType(JsonNode arrayNode) {
        if (arrayNode.size() == 0) {
            return String.class;
        }
        JsonNode entry = arrayNode.get(0);
        return this.getDataType(entry);
    }

    private final Class<?> getDataType(JsonNode entry) {
        if (entry.isArray()) {
            return List.class;
        }
        if (entry.isBoolean()) {
            return Boolean.class;
        }
        if (entry.isNumber()) {
            return Double.class;
        }
        return String.class;
    }

    private final Object getValue(JsonNode entry, CyColumn column) {
        if (entry.isArray()) {
            Iterator values = entry.elements();
            ArrayList<Object> list = new ArrayList<Object>();
            while (values.hasNext()) {
                list.add(this.parseValue((JsonNode)values.next(), column.getListElementType()));
            }
            return list;
        }
        return this.parseValue(entry, column.getType());
    }

    private final Object parseValue(JsonNode entry, Class<?> type) {
        if (type == Long.class) {
            return entry.longValue();
        }
        if (type == Integer.class) {
            return entry.intValue();
        }
        if (type == Float.class) {
            return Float.valueOf(entry.floatValue());
        }
        if (type == Double.class) {
            return entry.doubleValue();
        }
        if (type == Boolean.class) {
            return entry.booleanValue();
        }
        return entry.asText();
    }

    protected Map<CyNode, Double[]> getNodePosition() {
        return this.positionMap;
    }
}

