/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.nicecy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.io.internal.CxPreferences;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.internal.nicecy.Identifiable;
import org.cytoscape.io.internal.nicecy.NiceCyRootNetwork;
import org.cytoscape.io.internal.nicecy.NiceCyView;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.ndexbio.cxio.aspects.datamodels.AbstractAttributesAspectElement;
import org.ndexbio.cxio.aspects.datamodels.CyTableColumnElement;
import org.ndexbio.cxio.aspects.datamodels.EdgeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.HiddenAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NodeAttributesElement;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.misc.OpaqueElement;

public abstract class NiceCyNetwork
extends Identifiable {
    protected final List<CyTableColumnElement> tableColumns = new ArrayList<CyTableColumnElement>();
    protected List<NetworkAttributesElement> attributes = new ArrayList<NetworkAttributesElement>();
    protected List<HiddenAttributesElement> hiddenAttributes = new ArrayList<HiddenAttributesElement>();
    protected Map<Long, List<NodeAttributesElement>> nodeAttributes = new HashMap<Long, List<NodeAttributesElement>>();
    protected Map<Long, List<EdgeAttributesElement>> edgeAttributes = new HashMap<Long, List<EdgeAttributesElement>>();
    protected CyNetwork network;

    public NiceCyNetwork(long id) {
        super(id);
    }

    protected abstract String getNamespace();

    public List<NetworkAttributesElement> getAttributes() {
        return this.attributes;
    }

    public List<HiddenAttributesElement> getHiddenAttributes() {
        return this.hiddenAttributes;
    }

    public Map<Long, List<NodeAttributesElement>> getNodeAttributes() {
        return this.nodeAttributes;
    }

    public String getNetworkName() {
        for (NetworkAttributesElement nae : this.attributes) {
            if (!nae.getName().equals("name")) continue;
            return nae.getValue();
        }
        return null;
    }

    protected void serializeAspect(String column, Collection<AspectElement> collection) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        for (AspectElement el : collection) {
            OpaqueElement op = (OpaqueElement)el;
            nodes.add(op.getData());
        }
        CyTable table = this.network.getTable(CyNetwork.class, this.getNamespace());
        String aspectStr = mapper.writeValueAsString(nodes);
        CxUtil.createColumn(table, column, String.class, true);
        table.getRow((Object)this.network.getSUID()).set(column, (Object)aspectStr);
    }

    protected void addAttributes() {
        CyTable node_table = this.network.getTable(CyNode.class, "USER");
        CyTable node_local_table = this.network.getTable(CyNode.class, "LOCAL_ATTRS");
        CyTable edge_table = this.network.getTable(CyEdge.class, "USER");
        CyTable edge_local_table = this.network.getTable(CyEdge.class, "LOCAL_ATTRS");
        NiceCyRootNetwork root = this instanceof NiceCyRootNetwork ? (NiceCyRootNetwork)this : ((NiceCySubNetwork)this).parent;
        Long t0 = System.currentTimeMillis();
        this.addNetworkAttributesHelper((CyIdentifiable)this.network, this.attributes, this.hiddenAttributes);
        this.nodeAttributes.forEach((suid, attrs) -> {
            CyNode node = root.getNode((Long)suid);
            NiceCyNetwork.addAttributesHelper(node_table, node_local_table, (CyIdentifiable)node, attrs);
        });
        this.edgeAttributes.forEach((suid, attrs) -> {
            CyEdge edge = root.getEdge((Long)suid);
            NiceCyNetwork.addAttributesHelper(edge_table, edge_local_table, (CyIdentifiable)edge, attrs);
        });
        TimingUtil.reportTimeDifference(t0, "attributes of " + this.getNetworkName(), -1);
    }

    private void addNetworkAttributesHelper(CyIdentifiable ele, List<? extends AbstractAttributesAspectElement> attrs, List<? extends AbstractAttributesAspectElement> hidden_attrs) {
        CyTable sharedTable = this.network.getTable(CyNetwork.class, "USER");
        CyTable localTable = this.network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        CyRow sharedRow = sharedTable.getRow((Object)ele.getSUID());
        CyRow localRow = localTable.getRow((Object)ele.getSUID());
        CySubNetwork baseNetwork = this.network instanceof CySubNetwork ? ((CySubNetwork)this.network).getRootNetwork().getBaseNetwork() : ((CyRootNetwork)this.network).getBaseNetwork();
        CyTable baseSharedTable = baseNetwork.getTable(CyNetwork.class, "USER");
        CyTable baseLocalTable = baseNetwork.getTable(CyNetwork.class, "LOCAL_ATTRS");
        CyRow baseSharedRow = baseSharedTable.getRow((Object)baseNetwork.getSUID());
        CyRow baseLocalRow = baseLocalTable.getRow((Object)baseNetwork.getSUID());
        attrs.forEach(attr -> {
            CyRow row;
            CyTable baseTable;
            String name = attr.getName();
            boolean isLocal = attr.getSubnetwork() != null;
            CyTable table = isLocal ? localTable : sharedTable;
            CyTable cyTable = baseTable = isLocal ? baseLocalTable : baseSharedTable;
            if (table.getColumn(name) == null) {
                if (baseTable.getColumn(name) != null) {
                    row = isLocal ? baseLocalRow : baseSharedRow;
                } else {
                    CxUtil.createColumn(table, name, CxUtil.getDataType(attr.getDataType()), attr.isSingleValue());
                    row = isLocal ? localRow : sharedRow;
                }
            } else {
                row = isLocal ? localRow : sharedRow;
            }
            Object value = CxUtil.getValue(attr);
            try {
                row.set(name, value);
            }
            catch (NullPointerException e) {
                throw new NullPointerException("NullPointerException setting " + name + " to " + value + ". Is there a null value in a list?");
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Cannot set value in column %s(%s) to %s (type %s). %s", name, CxUtil.getDataType(attr.getDataType()), value, value.getClass(), e.getMessage());
                throw new IllegalArgumentException(message, e);
            }
        });
        CyTable hiddenTable = this.network.getTable(CyNetwork.class, "HIDDEN");
        CyRow hiddenRow = this.network.getRow(ele, "HIDDEN");
        hidden_attrs.forEach(attr -> {
            String name = attr.getName();
            if (hiddenTable.getColumn(name) == null) {
                CxUtil.createColumn(hiddenTable, name, CxUtil.getDataType(attr.getDataType()), attr.isSingleValue());
            }
            Object value = CxUtil.getValue(attr);
            try {
                hiddenRow.set(name, value);
            }
            catch (NullPointerException e) {
                throw new NullPointerException("NullPointerException setting " + name + " to " + value + ". Is there a null value in a list?");
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Cannot set value in column %s(%s) to %s (type %s). %s", name, CxUtil.getDataType(attr.getDataType()), value, value.getClass(), e.getMessage());
                throw new IllegalArgumentException(message, e);
            }
        });
    }

    private static void addAttributesHelper(CyTable sharedTable, CyTable localTable, CyIdentifiable ele, List<? extends AbstractAttributesAspectElement> attrs) {
        CyRow sharedRow = sharedTable.getRow((Object)ele.getSUID());
        CyRow localRow = localTable.getRow((Object)ele.getSUID());
        attrs.forEach(attr -> {
            CyRow row;
            String name = attr.getName();
            boolean isLocal = attr.getSubnetwork() != null;
            CyTable table = isLocal ? localTable : sharedTable;
            CyRow cyRow = row = isLocal ? localRow : sharedRow;
            if (table.getColumn(name) == null) {
                CxUtil.createColumn(table, name, CxUtil.getDataType(attr.getDataType()), attr.isSingleValue());
            }
            Object value = CxUtil.getValue(attr);
            try {
                row.set(name, value);
            }
            catch (NullPointerException e) {
                throw new NullPointerException("NullPointerException setting " + name + " to " + value + ". Is there a null value in a list?");
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Cannot set value in column %s(%s) to %s (type %s). %s", name, CxUtil.getDataType(attr.getDataType()), value, value.getClass(), e.getMessage());
                throw new IllegalArgumentException(message, e);
            }
        });
    }

    protected void addTableColumns() {
        this.tableColumns.forEach(column -> {
            CyTable table;
            String name = column.getName();
            boolean isLocal = column.getSubnetwork() != null;
            switch (column.getAppliesTo()) {
                case "node_table": {
                    table = isLocal ? this.network.getTable(CyNode.class, "LOCAL_ATTRS") : this.network.getTable(CyNode.class, "USER");
                    break;
                }
                case "edge_table": {
                    table = isLocal ? this.network.getTable(CyEdge.class, "LOCAL_ATTRS") : this.network.getTable(CyEdge.class, "USER");
                    break;
                }
                case "network_table": {
                    table = isLocal ? this.network.getTable(CyNetwork.class, "LOCAL_ATTRS") : this.network.getTable(CyNetwork.class, "USER");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized CyTableColumn applies_to: " + column.getAppliesTo());
                }
            }
            if (table.getColumn(name) == null) {
                CxUtil.createColumn(table, name, CxUtil.getDataType(column.getDataType()), column.isSingleValue());
            }
        });
    }

    public class NiceCySubNetwork
    extends NiceCyNetwork {
        protected final NiceCyRootNetwork parent;
        protected final List<Long> nodes;
        protected final List<Long> edges;
        protected final List<Long> groups;
        protected final Map<Long, NiceCyView> views;

        public NiceCySubNetwork(long id, NiceCyRootNetwork parent) {
            super(id);
            this.parent = parent;
            this.views = new HashMap<Long, NiceCyView>();
            this.nodes = new ArrayList<Long>();
            this.edges = new ArrayList<Long>();
            this.groups = new ArrayList<Long>();
        }

        protected void apply(CyNetwork network) {
            if (network == null) {
                throw new RuntimeException("Subnetwork can not be null");
            }
            this.network = network;
            this.addElements();
            this.addTableColumns();
            this.addAttributes();
        }

        private void addElements() {
            if (!this.parent.isCollection) {
                this.nodes.addAll(this.parent.root_nodes.keySet());
                this.edges.addAll(this.parent.root_edges.keySet());
                this.groups.addAll(this.parent.root_groups.keySet());
            }
            this.nodes.forEach(suid -> this.parent.root_nodes.get(suid).addTo((CySubNetwork)this.network));
            this.edges.forEach(suid -> {
                Identifiable.NiceCyEdge edge = this.parent.root_edges.get(suid);
                edge.addTo((CySubNetwork)this.network);
            });
            this.groups.forEach(suid -> {
                Identifiable.NiceCyGroup group = this.parent.root_groups.get(suid);
                group.addTo((CySubNetwork)this.network);
            });
        }

        @Override
        protected String getNamespace() {
            return "USER";
        }

        public Collection<? extends CyNetworkView> createViews(Boolean explicitCreateView) {
            ArrayList cy_views = new ArrayList();
            CyNetworkViewFactory view_factory = CyServiceModule.getService(CyNetworkViewFactory.class);
            CyNetworkViewManager view_manager = CyServiceModule.getService(CyNetworkViewManager.class);
            this.views.forEach((suid, view) -> {
                boolean hasExplicitView = !view.isCartesianLayoutEmpty() || !view.isVisualPropertiesEmpty() || !view.isNodeBypassEmpty() || !view.isEdgeBypassEmpty();
                long networkSize = this.network.getEdgeCount() + this.network.getNodeCount();
                long viewThreshold = CxPreferences.getViewThreshold();
                CxPreferences.CreateViewEnum createViewPreference = CxPreferences.getCreateView();
                System.out.println("View Preference: " + createViewPreference);
                System.out.println("Explicit Create View: " + explicitCreateView);
                boolean createView = explicitCreateView != null ? explicitCreateView : (CxPreferences.getCreateView() == CxPreferences.CreateViewEnum.NEVER ? false : createViewPreference.equals((Object)CxPreferences.CreateViewEnum.ALWAYS) || networkSize < viewThreshold);
                if (createView) {
                    CyNetworkView v = view_factory.createNetworkView(this.network);
                    view.apply(v);
                    view_manager.addNetworkView(v);
                    cy_views.add(v);
                }
            });
            return cy_views;
        }

        public void updateViewIds(NiceCySubNetwork otherNet) {
            String name;
            this.id = otherNet.getId();
            HashMap<String, NiceCyView> nameMap = new HashMap<String, NiceCyView>();
            for (NiceCyView view : otherNet.views.values()) {
                name = view.getName();
                if (nameMap.containsKey(name)) {
                    throw new RuntimeException("Cannot align views with duplicate names");
                }
                nameMap.put(name, view);
            }
            for (NiceCyView view : this.views.values()) {
                name = view.getName();
                if (!nameMap.containsKey(name)) {
                    throw new RuntimeException("View named " + name + " not in other");
                }
                this.views.remove(view.getId());
                NiceCyView otherView = (NiceCyView)nameMap.get(name);
                view.updateIds(otherView);
                this.views.put(view.getId(), view);
                nameMap.remove(name);
            }
        }

        public Collection<NiceCyView> getViews() {
            return this.views.values();
        }

        public List<Long> getNodes() {
            return this.nodes;
        }

        public List<Long> getEdges() {
            return this.edges;
        }

        public List<Long> getGroups() {
            return this.groups;
        }
    }
}

