/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal;

import java.util.Properties;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.property.CyProperty;

public class CxPreferences {
    public static final String VIEW_THRESHOLD = "viewThreshold";
    private static final int DEF_VIEW_THRESHOLD = 200000;
    public static final String CREATE_VIEW_PROPERTY = "cx.createView";
    public static final String APPLY_LAYOUT_PROPERTY = "cx.applyLayout";
    public static final String LARGE_LAYOUT_THRESHOLD_PROPERTY = "cx.largeLayoutThreshold";
    public static final int DEF_LARGE_LAYOUT_THRESHOLD = 25000;

    public static int getViewThreshold() {
        return CxPreferences.getIntegerProperty(VIEW_THRESHOLD, 200000);
    }

    public static CreateViewEnum getCreateView() {
        String property = CxPreferences.getProperty(CREATE_VIEW_PROPERTY);
        System.out.println("CREATE_VIEW_PROPERTY=" + property);
        return CreateViewEnum.ALWAYS.toString().toLowerCase().equals(property) ? CreateViewEnum.ALWAYS : (CreateViewEnum.NEVER.toString().toLowerCase().equals(property) ? CreateViewEnum.NEVER : CreateViewEnum.AUTO);
    }

    public static ApplyLayoutEnum getApplyLayout() {
        String property = CxPreferences.getProperty(APPLY_LAYOUT_PROPERTY);
        return ApplyLayoutEnum.NEVER.toString().toLowerCase().equals(property) ? ApplyLayoutEnum.NEVER : ApplyLayoutEnum.AUTO;
    }

    public static Integer getLargeLayoutThreshold() {
        return CxPreferences.getIntegerProperty(LARGE_LAYOUT_THRESHOLD_PROPERTY, 25000);
    }

    private static String getProperty(String key) {
        Properties props = (Properties)CyServiceModule.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)").getProperties();
        return props.getProperty(key);
    }

    private static Integer getIntegerProperty(String key, Integer defaultValue) {
        String property = CxPreferences.getProperty(key);
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static enum ApplyLayoutEnum {
        AUTO,
        NEVER;

    }

    public static enum CreateViewEnum {
        ALWAYS,
        AUTO,
        NEVER;

    }
}

