/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.legend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.legend.AbstractMappingLegendPanel;
import org.cytoscape.view.vizmap.gui.internal.view.legend.ContinuousLegendPanel;
import org.cytoscape.view.vizmap.gui.internal.view.legend.DiscreteLegendPanel;
import org.cytoscape.view.vizmap.gui.internal.view.legend.PassthroughLegendPanel;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsio.gif.GIFExportFileType;
import org.freehep.graphicsio.pdf.PDFExportFileType;
import org.freehep.graphicsio.raw.RawImageWriterSpi;
import org.freehep.graphicsio.svg.SVGExportFileType;

public class LegendDialog
extends JDialog {
    protected final Color BACKGROUND_COLOR = Color.WHITE;
    protected final Color TITLE_COLOR = Color.BLACK;
    private final VisualStyle visualStyle;
    private JPanel panel;
    private JButton exportBtn;
    private JButton cancelBtn;
    private JScrollPane scrollPane;
    private final ServicesUtil servicesUtil;

    public LegendDialog(VisualStyle vs, ServicesUtil servicesUtil) {
        this.setModal(true);
        this.visualStyle = vs;
        this.servicesUtil = servicesUtil;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        IIORegistry reg = IIORegistry.getDefaultInstance();
        reg.registerApplicationClasspathSpis();
        reg.registerServiceProvider(new RawImageWriterSpi(), ImageWriterSpi.class);
    }

    public void showDialog(Component parent) {
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private JPanel generateLegendPanel(VisualStyle visualStyle) {
        JPanel legend = new JPanel();
        legend.setLayout(new BoxLayout(legend, 1));
        legend.setBackground(this.BACKGROUND_COLOR);
        Collection mappings = visualStyle.getAllVisualMappingFunctions();
        legend.setBorder(new TitledBorder(new LineBorder(this.TITLE_COLOR, 1), "Visual Legend for " + visualStyle.getTitle(), 0, 2, new Font("SansSerif", 1, 16), this.TITLE_COLOR));
        this.createMappingLegends(mappings, legend);
        return legend;
    }

    private void createMappingLegends(Collection<VisualMappingFunction<?, ?>> mappings, JPanel legend) {
        for (VisualMappingFunction<?, ?> map : mappings) {
            AbstractMappingLegendPanel mappingLegend;
            CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
            if (map instanceof ContinuousMapping) {
                mappingLegend = new ContinuousLegendPanel(this.visualStyle, (ContinuousMapping)map, appMgr.getCurrentNetwork().getDefaultNodeTable(), this.servicesUtil);
            } else if (map instanceof DiscreteMapping) {
                mappingLegend = new DiscreteLegendPanel((DiscreteMapping)map, this.servicesUtil);
            } else {
                if (!(map instanceof DiscreteMapping)) continue;
                mappingLegend = new PassthroughLegendPanel((PassthroughMapping)map, this.servicesUtil);
            }
            if (map instanceof PassthroughMapping) {
                legend.add((Component)mappingLegend, 0);
            } else {
                legend.add(mappingLegend);
            }
            mappingLegend.setBorder(new EmptyBorder(15, 30, 15, 30));
        }
    }

    private void initComponents() {
        this.setBackground(this.BACKGROUND_COLOR);
        this.setTitle("Visual Legend for " + this.visualStyle.getTitle() + " ");
        this.panel = this.generateLegendPanel(this.visualStyle);
        this.scrollPane = new JScrollPane(this.panel);
        this.exportBtn = new JButton(new AbstractAction("Export"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendDialog.this.export();
            }
        });
        this.cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendDialog.this.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.exportBtn, (JButton)this.cancelBtn);
        JPanel contentPane = new JPanel();
        GroupLayout layout = new GroupLayout(contentPane);
        contentPane.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.scrollPane).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.scrollPane).addComponent(buttonPanel));
        this.setContentPane(contentPane);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.exportBtn.getAction(), (Action)this.cancelBtn.getAction());
        this.getRootPane().setDefaultButton(this.exportBtn);
        this.setPreferredSize(new Dimension(650, 500));
        this.pack();
        this.repaint();
    }

    private void export() {
        ExportDialog export = new ExportDialog(null, false);
        export.addExportFileType((ExportFileType)new SVGExportFileType());
        export.addExportFileType((ExportFileType)new GIFExportFileType());
        export.addExportFileType((ExportFileType)new PDFExportFileType());
        export.showExportDialog(null, "Export legend as ...", (Component)this.panel, "legend");
        this.dispose();
    }
}

