/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.VisualPropertyValue;
import org.cytoscape.view.vizmap.gui.editor.VisualPropertyValueEditor;
import org.cytoscape.view.vizmap.gui.internal.CurrentTableService;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.VisualPropertyUtil;
import org.cytoscape.view.vizmap.gui.internal.view.cellrenderer.FontCellRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.cellrenderer.IconCellRenderer;
import org.jdesktop.swingx.JXList;

public class DiscreteValueEditor<T>
implements VisualPropertyValueEditor<T> {
    protected final Class<T> type;
    protected final Set<T> values;
    protected final ServicesUtil servicesUtil;
    protected boolean canceled;
    protected DiscreteValueDialog dialog;

    public DiscreteValueEditor(Class<T> type, Set<T> values, ServicesUtil servicesUtil) {
        if (type == null) {
            throw new IllegalArgumentException("'type' must not be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be null.");
        }
        if (servicesUtil == null) {
            throw new IllegalArgumentException("'servicesUtil' must not be null.");
        }
        this.values = values;
        this.type = type;
        this.servicesUtil = servicesUtil;
    }

    public T getValue() {
        return (T)(!this.canceled ? this.dialog.getDiscreteValueList().getSelectedValue() : null);
    }

    public void setValue(T value) {
        this.dialog.getDiscreteValueList().setSelectedValue(value, true);
    }

    @Override
    public <S extends T> T showEditor(Component parent, S initialValue, VisualProperty<S> vp) {
        if (this.dialog == null) {
            this.dialog = new DiscreteValueDialog(JOptionPane.getFrameForComponent(parent));
        }
        this.dialog.setTitle(vp != null ? vp.getDisplayName() : "Select New Value");
        Set<T> supportedValues = this.getSupportedValues(vp);
        this.dialog.getDiscreteValueList().setVisualProperty(vp);
        this.dialog.getDiscreteValueList().setListItems(supportedValues, initialValue);
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        Object newValue = this.getValue();
        this.canceled = false;
        if (newValue == null) {
            newValue = initialValue;
        }
        return newValue;
    }

    @Override
    public Class<T> getValueType() {
        return this.type;
    }

    private <S extends T> Set<T> getSupportedValues(VisualProperty<S> vp) {
        if (vp == null) {
            return this.values;
        }
        VisualLexicon lexicon = this.servicesUtil.get(CurrentTableService.class).getCurrentVisualLexicon(vp);
        return lexicon.getSupportedValueRange(vp);
    }

    static class DiscreteValueList<T>
    extends JXList {
        private int iconWidth = -1;
        private int iconHeight = -1;
        private final Class<T> type;
        private VisualProperty<T> visualProperty;
        private final Map<T, Icon> iconMap;
        private final DefaultListModel<T> model;
        private final ServicesUtil servicesUtil;

        DiscreteValueList(Class<T> type, ServicesUtil servicesUtil) {
            this.type = type;
            this.servicesUtil = servicesUtil;
            this.iconMap = new HashMap<T, Icon>();
            this.model = new DefaultListModel();
            this.setModel(this.model);
            this.setCellRenderer((ListCellRenderer)(type == Font.class ? new FontCellRenderer() : new IconCellRenderer<T>(this.iconMap)));
            this.setAutoCreateRowSorter(true);
            this.setSortOrder(SortOrder.ASCENDING);
            this.setSelectionMode(0);
            this.setCursor(new Cursor(12));
            final Collator collator = Collator.getInstance(Locale.getDefault());
            this.setComparator(new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    if (o1 instanceof VisualPropertyValue) {
                        return collator.compare(((VisualPropertyValue)o1).getDisplayName(), ((VisualPropertyValue)o2).getDisplayName());
                    }
                    if (o1 instanceof Font) {
                        return collator.compare(((Font)o1).getFontName(), ((Font)o2).getFontName());
                    }
                    return collator.compare(o1.toString(), o2.toString());
                }
            });
        }

        void setVisualProperty(VisualProperty<T> visualProperty) {
            this.visualProperty = visualProperty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderIcons(Set<T> values) {
            if (this.type == Font.class) {
                return;
            }
            this.iconMap.clear();
            CurrentTableService currentTableService = this.servicesUtil.get(CurrentTableService.class);
            RenderingEngine<?> engine = currentTableService.getRenderingEngine(this.visualProperty);
            if (engine != null) {
                Set<T> set = values;
                synchronized (set) {
                    for (T value : values) {
                        Icon icon = null;
                        if (value instanceof CyCustomGraphics) {
                            Image img = ((CyCustomGraphics)value).getRenderedImage();
                            if (img != null) {
                                icon = VisualPropertyUtil.resizeIcon(new ImageIcon(img), this.getIconWidth(), this.getIconHeight());
                            }
                        } else if (this.visualProperty != null) {
                            icon = engine.createIcon(this.visualProperty, value, this.getIconWidth(), this.getIconHeight());
                        }
                        if (icon == null) continue;
                        this.iconMap.put(value, icon);
                    }
                }
            }
        }

        void setListItems(Set<T> newValues, T selectedValue) {
            this.renderIcons(newValues);
            this.model.removeAllElements();
            for (T key : newValues) {
                this.model.addElement(key);
            }
            if (selectedValue != null) {
                this.setSelectedValue(selectedValue, true);
            }
            this.repaint();
        }

        private int getIconWidth() {
            if (this.iconWidth == -1) {
                this.iconWidth = this.type == LineType.class || this.type == ArrowShape.class ? 64 : 32;
            }
            return this.iconWidth;
        }

        private int getIconHeight() {
            if (this.iconHeight == -1) {
                this.iconHeight = 32;
            }
            return this.iconHeight;
        }
    }

    protected class DiscreteValueDialog
    extends JDialog {
        protected JButton applyButton;
        protected JButton cancelButton;
        protected DiscreteValueList<T> discreteValueList;
        protected JScrollPane iconListScrollPane;
        protected JPanel mainPanel;

        protected DiscreteValueDialog(Window owner) {
            super(owner, Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.iconListScrollPane = new JScrollPane();
            this.iconListScrollPane.setViewportView((Component)((Object)this.getDiscreteValueList()));
            this.mainPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.mainPanel);
            this.mainPanel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(128, Short.MAX_VALUE).addComponent(this.getCancelButton()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getApplyButton()).addContainerGap()).addComponent(this.iconListScrollPane, -1, 291, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.iconListScrollPane, -1, 312, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getApplyButton()).addComponent(this.getCancelButton())).addContainerGap()));
            JPanel contentPane = new JPanel();
            GroupLayout layout2 = new GroupLayout(contentPane);
            contentPane.setLayout(layout2);
            layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
            layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
            this.setContentPane(contentPane);
            this.pack();
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getApplyButton().getAction(), (Action)this.getCancelButton().getAction());
            this.getRootPane().setDefaultButton(this.getApplyButton());
        }

        private DiscreteValueList<T> getDiscreteValueList() {
            if (this.discreteValueList == null) {
                this.discreteValueList = new DiscreteValueList(DiscreteValueEditor.this.type, DiscreteValueEditor.this.servicesUtil);
                this.discreteValueList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        if (evt.getClickCount() == 2) {
                            DiscreteValueDialog.this.getApplyButton().doClick();
                        }
                    }
                });
            }
            return this.discreteValueList;
        }

        private JButton getApplyButton() {
            if (this.applyButton == null) {
                this.applyButton = new JButton(new AbstractAction("Apply"){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DiscreteValueEditor.this.dialog.dispose();
                    }
                });
            }
            return this.applyButton;
        }

        private JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = new JButton(new AbstractAction("Cancel"){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        DiscreteValueEditor.this.dialog.dispose();
                        DiscreteValueEditor.this.canceled = true;
                    }
                });
                this.cancelButton.setVisible(true);
            }
            return this.cancelButton;
        }
    }
}

