/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;

public class CyStringPropertyEditor
extends AbstractPropertyEditor {
    private JTextField textFld;
    private JButton editBtn;
    private String currentValue;
    private String newValue;
    private boolean ignoreDocumentEvents;

    public CyStringPropertyEditor(ServicesUtil servicesUtil) {
        IconManager iconManager = servicesUtil.get(IconManager.class);
        this.editor = new JPanel((LayoutManager)new PercentLayout(0, 0)){

            @Override
            public void addNotify() {
                super.addNotify();
                if (CyStringPropertyEditor.this.isMultiLine(CyStringPropertyEditor.this.currentValue)) {
                    CyStringPropertyEditor.this.textFld.setEnabled(false);
                    CyStringPropertyEditor.this.editBtn.requestFocusInWindow();
                } else {
                    CyStringPropertyEditor.this.textFld.setEnabled(true);
                    CyStringPropertyEditor.this.textFld.selectAll();
                }
            }

            @Override
            public void removeNotify() {
                CyStringPropertyEditor.this.checkChange();
                super.removeNotify();
            }
        };
        ((JPanel)this.editor).setOpaque(false);
        this.editor.setFocusable(false);
        this.textFld = new JTextField();
        ((JPanel)this.editor).add("*", this.textFld);
        this.textFld.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.textFld});
        this.textFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                CyStringPropertyEditor.this.onTextFieldUpdated(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                CyStringPropertyEditor.this.onTextFieldUpdated(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                CyStringPropertyEditor.this.onTextFieldUpdated(evt);
            }
        });
        this.textFld.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2 && CyStringPropertyEditor.this.isMultiLine(CyStringPropertyEditor.this.currentValue)) {
                    CyStringPropertyEditor.this.showPopupEditor();
                }
            }
        });
        this.editBtn = ComponentFactory.Helper.getFactory().createMiniButton();
        ((JPanel)this.editor).add(this.editBtn);
        this.editBtn.setText("\uf141");
        this.editBtn.setToolTipText("Edit Text...");
        this.editBtn.setFont(iconManager.getIconFont(14.0f));
        this.editBtn.addActionListener(evt -> this.showPopupEditor());
    }

    public Object getValue() {
        return this.currentValue;
    }

    public void setValue(Object value) {
        this.newValue = this.currentValue = (String)value;
        this.ignoreDocumentEvents = true;
        this.textFld.setText(this.currentValue);
        this.ignoreDocumentEvents = false;
    }

    private void onTextFieldUpdated(DocumentEvent evt) {
        if (!this.ignoreDocumentEvents) {
            this.newValue = this.textFld.getText();
        }
    }

    private void checkChange() {
        if (!Objects.equals(this.currentValue, this.newValue)) {
            String oldValue = this.currentValue;
            this.currentValue = this.newValue;
            this.firePropertyChange(oldValue, this.newValue);
        }
    }

    private void showPopupEditor() {
        this.newValue = ViewUtil.showMultiLineTextEditor(this.textFld, this.newValue);
        this.checkChange();
        this.ignoreDocumentEvents = true;
        this.textFld.setText(this.newValue);
        this.ignoreDocumentEvents = false;
    }

    private boolean isMultiLine(String value) {
        return value != null && value.contains("\n");
    }
}

