/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import com.l2fprod.common.beans.editor.StringPropertyEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import org.cytoscape.view.model.VisualProperty;

public class CyNumberPropertyEditor<T extends Number>
extends StringPropertyEditor {
    private Object currentValue;
    private VisualProperty<T> visualProperty;
    private final Class<T> type;

    public CyNumberPropertyEditor(Class<T> type) {
        this.type = type;
        ((JTextField)this.editor).setHorizontalAlignment(4);
        ((JTextField)this.editor).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CyNumberPropertyEditor.this.setCurrentValue();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CyNumberPropertyEditor.this.checkChange();
            }
        });
    }

    private void setCurrentValue() {
        this.currentValue = this.getValue();
    }

    private void checkChange() {
        String s = (String)this.getValue();
        Number newValue = this.parse(s);
        if (newValue != null) {
            if (this.visualProperty != null) {
                boolean isInRange = this.visualProperty.getRange().inRange((Object)newValue);
                if (!isInRange) {
                    newValue = (Number)this.visualProperty.getDefault();
                    ((JTextField)this.editor).setText(newValue.toString());
                }
            } else if (newValue.doubleValue() <= 0.0) {
                newValue = this.parse("0");
                ((JTextField)this.editor).setText(newValue.toString());
            }
        } else {
            ((JTextField)this.editor).setText("");
        }
        this.editor.repaint();
        if (this.currentValue == null && newValue != null || this.currentValue != null && !this.currentValue.equals(newValue)) {
            this.firePropertyChange(this.currentValue, newValue);
        }
    }

    public void setVisualProperty(VisualProperty<T> visualProperty) {
        this.visualProperty = visualProperty;
    }

    private Number parse(String s) {
        Number value = null;
        try {
            if (s != null) {
                s = s.trim();
                if (this.type == Double.class) {
                    value = Double.parseDouble(s);
                } else if (this.type == Float.class) {
                    value = Float.valueOf(Float.parseFloat(s));
                } else if (this.type == Long.class) {
                    value = Long.parseLong(s);
                } else if (this.type == Integer.class) {
                    value = Integer.parseInt(s);
                } else if (this.type == Short.class) {
                    value = Short.parseShort(s);
                } else if (this.type == Byte.class) {
                    value = Byte.parseByte(s);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

