/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;

public class CyFontPropertyEditor
extends CyComboBoxPropertyEditor {
    protected static final float FONT_SIZE = 14.0f;
    private final List<Font> fonts = this.scaleFonts(ViewUtil.getAvailableFonts());

    public CyFontPropertyEditor() {
        JComboBox comboBox = (JComboBox)this.editor;
        comboBox.setRenderer(new FontCellRenderer());
        comboBox.addActionListener(evt -> this.updateComboBox());
    }

    private void updateComboBox() {
        JComboBox box = (JComboBox)this.editor;
        Object selected = box.getSelectedItem();
        box.removeAllItems();
        for (Font f : this.fonts) {
            box.addItem(f);
        }
        box.setSelectedItem(selected);
    }

    private List<Font> scaleFonts(Collection<Font> inFonts) {
        ArrayList<Font> outFonts = new ArrayList<Font>(inFonts.size());
        for (Font f : inFonts) {
            outFonts.add(f.deriveFont(14.0f));
        }
        return outFonts;
    }

    private static class FontCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Dimension SIZE = new Dimension(280, 32);

        private FontCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setPreferredSize(SIZE);
            this.setMinimumSize(SIZE);
            this.setOpaque(true);
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            if (value != null && value instanceof Font) {
                Font font = (Font)value;
                this.setFont(font);
                this.setText(font.getName());
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

