/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.PercentLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.cellrenderer.CyColorCellRenderer;
import org.cytoscape.view.vizmap.gui.internal.view.editor.valueeditor.CyColorChooser;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;

public class CyColorPropertyEditor
extends AbstractPropertyEditor {
    private CyColorCellRenderer label;
    private JButton editBtn;
    private JButton removeBtn;
    private Color color = Color.WHITE;
    private final CyColorChooser chooser;

    public CyColorPropertyEditor(CyColorChooser chooser, ServicesUtil servicesUtil) {
        this.chooser = chooser;
        ViewUtil.invokeOnEDT(() -> {
            IconManager iconManager = servicesUtil.get(IconManager.class);
            this.editor = new JPanel((LayoutManager)new PercentLayout(0, 0));
            this.label = new CyColorCellRenderer();
            ((JPanel)this.editor).add("*", (Component)((Object)this.label));
            this.label.setOpaque(false);
            this.editBtn = ComponentFactory.Helper.getFactory().createMiniButton();
            ((JPanel)this.editor).add(this.editBtn);
            this.editBtn.setText("\uf141");
            this.editBtn.setToolTipText("Edit Color...");
            this.editBtn.setFont(iconManager.getIconFont(14.0f));
            this.editBtn.addActionListener(e -> this.selectColor());
            this.removeBtn = ComponentFactory.Helper.getFactory().createMiniButton();
            ((JPanel)this.editor).add(this.removeBtn);
            this.removeBtn.setText("\uf014");
            this.removeBtn.setToolTipText("Remove Color");
            this.removeBtn.setFont(iconManager.getIconFont(14.0f));
            this.removeBtn.addActionListener(e -> this.selectNull());
            ((JPanel)this.editor).setOpaque(false);
            this.setKeyBindings((JPanel)this.editor);
        });
    }

    public Object getValue() {
        return this.color;
    }

    public void setValue(Object value) {
        this.color = (Color)value;
        this.label.setValue(this.color);
    }

    private void selectColor() {
        Paint selectedColor = this.chooser.showEditor(this.editor, this.color);
        if (!(selectedColor instanceof Color)) {
            return;
        }
        if (selectedColor != null) {
            Color oldColor = this.color;
            Color newColor = (Color)selectedColor;
            this.label.setValue(newColor);
            this.color = newColor;
            this.firePropertyChange(oldColor, newColor);
        }
    }

    protected void selectNull() {
        Color oldColor = this.color;
        this.label.setValue(null);
        this.color = null;
        this.firePropertyChange(oldColor, null);
    }

    private void setKeyBindings(JPanel panel) {
        ActionMap actionMap = panel.getActionMap();
        InputMap inputMap = panel.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "VK_SPACE");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "VK_DELETE");
        actionMap.put("VK_SPACE", new KeyAction("VK_SPACE"));
        actionMap.put("VK_DELETE", new KeyAction("VK_DELETE"));
    }

    private class KeyAction
    extends AbstractAction {
        static final String VK_SPACE = "VK_SPACE";
        static final String VK_DELETE = "VK_DELETE";

        KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(VK_SPACE)) {
                CyColorPropertyEditor.this.selectColor();
            } else if (cmd.equals(VK_DELETE)) {
                CyColorPropertyEditor.this.selectNull();
            }
        }
    }
}

