/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor;

import java.awt.Component;
import java.text.Collator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.gui.editor.ListEditor;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSet;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.CyComboBoxPropertyEditor;

public final class AttributeComboBoxPropertyEditor
extends CyComboBoxPropertyEditor
implements ListEditor {
    private final Class<? extends CyIdentifiable> graphObjectType;
    private final AttributeSetProxy attrProxy;
    private final CyNetworkManager networkManager;
    private final CyColumnPresentationManager columnPresentationManager;
    private Map<String, Class<?>> currentColumnMap = new HashMap();

    public AttributeComboBoxPropertyEditor(Class<? extends CyIdentifiable> type, AttributeSetProxy attrProxy, CyApplicationManager appManager, CyNetworkManager networkManager, CyColumnPresentationManager columnPresentationManager) {
        this.attrProxy = attrProxy;
        this.graphObjectType = type;
        this.networkManager = networkManager;
        this.columnPresentationManager = columnPresentationManager;
        JComboBox comboBox = (JComboBox)this.editor;
        comboBox.setRenderer(new AttributeComboBoxCellRenderer());
        comboBox.addActionListener(e -> {
            if (type == CyColumn.class) {
                this.updateComboBox(appManager.getCurrentTable());
            } else {
                this.updateComboBox(appManager.getCurrentNetwork());
            }
        });
    }

    @Override
    public Class<?> getTargetObjectType() {
        return this.graphObjectType;
    }

    private void updateComboBox(CyTable table) {
        JComboBox box = (JComboBox)this.editor;
        Object selected = box.getSelectedItem();
        box.removeAllItems();
        if (table == null) {
            return;
        }
        Collator collator = Collator.getInstance(Locale.getDefault());
        TreeSet<Object> sortedName = new TreeSet<Object>(collator);
        AttributeSet currentSet = this.attrProxy.getAttributeSet(table);
        this.currentColumnMap = currentSet.getAttrMap();
        for (Map.Entry<String, Class<?>> entry : currentSet.getAttrMap().entrySet()) {
            if (!this.columnIsAllowed(entry.getKey(), entry.getValue())) continue;
            sortedName.add(entry.getKey());
        }
        for (String string : sortedName) {
            box.addItem(string);
        }
        box.setSelectedItem(selected);
    }

    private void updateComboBox(CyNetwork currentNetwork) {
        JComboBox box = (JComboBox)this.editor;
        Object selected = box.getSelectedItem();
        box.removeAllItems();
        if (currentNetwork == null) {
            return;
        }
        AttributeSet compatibleColumns = this.attrProxy.getAttributeSet(currentNetwork, this.graphObjectType);
        this.currentColumnMap = compatibleColumns.getAttrMap();
        AttributeSet targetSet = this.attrProxy.getAttributeSet(currentNetwork, this.graphObjectType);
        if (targetSet == null) {
            return;
        }
        Collator collator = Collator.getInstance(Locale.getDefault());
        TreeSet<Object> sortedName = new TreeSet<Object>(collator);
        Set networks = this.networkManager.getNetworkSet();
        for (CyNetwork cyNetwork : networks) {
            AttributeSet currentSet = this.attrProxy.getAttributeSet(cyNetwork, this.graphObjectType);
            for (Map.Entry<String, Class<?>> entry : currentSet.getAttrMap().entrySet()) {
                if (!this.columnIsAllowed(entry.getKey(), entry.getValue())) continue;
                sortedName.add(entry.getKey());
            }
        }
        for (String string : sortedName) {
            box.addItem(string);
        }
        box.setSelectedItem(selected);
    }

    private boolean columnIsAllowed(String name, Class<?> type) {
        if (!Long.class.equals(type) && !List.class.equals(type)) {
            return true;
        }
        return !"SUID".equals(name) && !name.endsWith(".SUID");
    }

    private final class AttributeComboBoxCellRenderer
    extends CyComboBoxPropertyEditor.Renderer {
        private static final long serialVersionUID = 6828337202195089669L;

        private AttributeComboBoxCellRenderer() {
            super(AttributeComboBoxPropertyEditor.this);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return component;
            }
            JLabel lbl = component instanceof JLabel ? (JLabel)component : new JLabel();
            AttributeComboBoxPropertyEditor.this.columnPresentationManager.setLabel(value.toString(), lbl);
            Set<String> keys = AttributeComboBoxPropertyEditor.this.currentColumnMap.keySet();
            String valueString = value.toString();
            if (keys != null && !keys.contains(valueString)) {
                this.setEnabled(false);
                this.setFocusable(false);
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
                this.setToolTipText("This column does not exist in current network's table.");
            } else {
                this.setEnabled(true);
                this.setFocusable(true);
                this.setToolTipText("<html>Column: " + value.toString() + "<br>Data Type: " + AttributeComboBoxPropertyEditor.this.currentColumnMap.get(valueString).getSimpleName() + "</html>");
            }
            return lbl;
        }
    }
}

