/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualProperty;

public class YValueLegendPanel
extends JPanel {
    private static final long serialVersionUID = 1202339877453677L;
    private final int xOffset = LookAndFeelUtil.isWinLAF() ? 20 : 5;
    private VisualProperty<?> type;

    public YValueLegendPanel(VisualProperty<?> type) {
        this.type = type;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.clear(g);
        Graphics2D g2d = (Graphics2D)g;
        int panelHeight = this.getHeight() - 30;
        Polygon poly = new Polygon();
        int top = 10;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        int center = this.getWidth() / 2 + 4;
        poly.addPoint(center, top);
        poly.addPoint(center - 6, top + 15);
        poly.addPoint(center, top + 15);
        g.fillPolygon(poly);
        g2d.setColor(UIManager.getColor("Label.disabledForeground"));
        g2d.drawLine(center, top, center, panelHeight);
        g2d.setFont(UIManager.getFont("Label.font").deriveFont(1, LookAndFeelUtil.getSmallFontSize()));
        String label = this.type.getDisplayName();
        int width = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), label);
        AffineTransform af = new AffineTransform();
        af.rotate(4.71238898038469);
        g2d.setTransform(af);
        g2d.setColor(UIManager.getColor("Label.foreground"));
        g2d.drawString(this.type.getDisplayName(), -this.getHeight() / 2 - width / 2, this.getWidth() / 2 + this.xOffset);
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }
}

