/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class MinMaxDialog
extends JDialog {
    private static MinMaxDialog dialog;
    private JButton cancelButton;
    private JLabel maxLabel;
    private JTextField maxTextField;
    private JLabel minLabel;
    private JTextField minTextField;
    private JButton okButton;
    private JPanel mainPanel;
    private JButton colMinMaxButton;
    private Double min;
    private Double max;
    private double colMin;
    private double colMax;

    public MinMaxDialog(Window parent, double min, double max, double colMin, double colMax) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(parent);
        this.min = min;
        this.max = max;
        this.colMin = colMin;
        this.colMax = colMax;
        this.initComponents();
        this.minTextField.setText(String.valueOf(min));
        this.maxTextField.setText(String.valueOf(max));
    }

    public static Double[] getMinMax(double min, double max, double colMin, double colMax, Window parent) {
        Double[] minMax = new Double[2];
        dialog = new MinMaxDialog(parent, min, max, colMin, colMax);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (MinMaxDialog.dialog.min == null || MinMaxDialog.dialog.max == null) {
            return null;
        }
        minMax[0] = MinMaxDialog.dialog.min;
        minMax[1] = MinMaxDialog.dialog.max;
        return minMax;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Set Range");
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setResizable(false);
        this.minLabel = new JLabel("Min:");
        this.maxLabel = new JLabel("Max:");
        this.minTextField = new JTextField();
        this.minTextField.setHorizontalAlignment(4);
        this.maxTextField = new JTextField();
        this.maxTextField.setHorizontalAlignment(4);
        this.colMinMaxButton = new JButton("Reset");
        this.colMinMaxButton.addActionListener(e -> {
            this.minTextField.setText(String.valueOf(this.colMin));
            this.maxTextField.setText(String.valueOf(this.colMax));
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton());
        JPanel contents = new JPanel();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getMainPanel(), -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getMainPanel(), -2, -1, -2).addComponent(buttonPanel, -2, -1, -2));
        this.getContentPane().add(contents);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getOkButton().getAction(), (Action)this.getCancelButton().getAction());
        this.getRootPane().setDefaultButton(this.getOkButton());
        this.pack();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Set Value Range"));
            GroupLayout layout = new GroupLayout(this.mainPanel);
            this.mainPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minLabel).addComponent(this.maxLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.minTextField, 182, 182, 182).addComponent(this.maxTextField, 182, 182, 182).addComponent(this.colMinMaxButton, GroupLayout.Alignment.TRAILING)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.minLabel).addComponent(this.minTextField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.maxLabel).addComponent(this.maxTextField)).addComponent(this.colMinMaxButton));
        }
        return this.mainPanel;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MinMaxDialog.this.min = null;
                    MinMaxDialog.this.max = null;
                    MinMaxDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MinMaxDialog.this.min = Double.valueOf(MinMaxDialog.this.minTextField.getText());
                        MinMaxDialog.this.max = Double.valueOf(MinMaxDialog.this.maxTextField.getText());
                    }
                    catch (NumberFormatException nfe) {
                        MinMaxDialog.this.min = null;
                        MinMaxDialog.this.max = null;
                    }
                    MinMaxDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }
}

