/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.GradientEditorPanel;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;

final class BelowAndAbovePanel
extends JPanel {
    private static final long serialVersionUID = 1202339876961477L;
    public static final int ARROW_SIZE = 18;
    public static final Stroke OUTLINE_STROKE = new BasicStroke(1.0f);
    private final VisualProperty<?> vp;
    private final boolean isBelow;
    private Color boxColor;
    private final ContinuousMapping<?, ?> mapping;
    private final ContinuousMappingEditorPanel parentPanel;

    BelowAndAbovePanel(Color color, boolean below, ContinuousMapping<?, ?> mapping, ContinuousMappingEditorPanel<?, ?> parentPanel) {
        this.boxColor = color;
        this.isBelow = below;
        this.mapping = mapping;
        this.vp = mapping.getVisualProperty();
        this.parentPanel = parentPanel;
        if (below) {
            this.setToolTipText("Double-click triangle to set below color...");
        } else {
            this.setToolTipText("Double-click triangle to set above color...");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BelowAndAbovePanel.this.processDoubleClick(e);
            }
        });
    }

    private void processDoubleClick(MouseEvent e) {
        if (e.getClickCount() == 2) {
            Color newValue = null;
            if (!Paint.class.isAssignableFrom(this.vp.getRange().getType())) {
                return;
            }
            newValue = ((GradientEditorPanel)this.parentPanel).changeThumbColor(this.boxColor);
            if (newValue == null) {
                return;
            }
            this.setColor(newValue);
            BoundaryRangeValues brv = null;
            TreeMap<Double, ContinuousMappingPoint> sortedPoints = new TreeMap<Double, ContinuousMappingPoint>();
            for (Object point : this.mapping.getAllPoints()) {
                ContinuousMappingPoint p = (ContinuousMappingPoint)point;
                Number val = (Number)p.getValue();
                sortedPoints.put(val.doubleValue(), p);
            }
            if (this.mapping.getPointCount() != 0) {
                ContinuousMappingPoint originalPoint;
                if (this.isBelow) {
                    originalPoint = (ContinuousMappingPoint)sortedPoints.get(sortedPoints.firstKey());
                    BoundaryRangeValues original = originalPoint.getRange();
                    brv = new BoundaryRangeValues((Object)newValue, original.equalValue, original.greaterValue);
                } else {
                    originalPoint = (ContinuousMappingPoint)sortedPoints.get(sortedPoints.lastKey());
                    BoundaryRangeValues original = originalPoint.getRange();
                    brv = new BoundaryRangeValues(original.lesserValue, original.equalValue, (Object)newValue);
                }
                originalPoint.setRange(brv);
            }
            if (this.isBelow) {
                this.parentPanel.below = newValue;
            } else {
                this.parentPanel.above = newValue;
            }
            ((GradientEditorPanel)this.parentPanel).initSlider();
            ((GradientEditorPanel)this.parentPanel).updateView();
        }
    }

    public void setColor(Color newColor) {
        this.boxColor = newColor;
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Polygon poly = new Polygon();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(OUTLINE_STROKE);
        g2d.setColor(this.boxColor);
        if (this.isBelow) {
            int cw = this.getSize().width;
            poly.addPoint(cw, 0);
            poly.addPoint(cw, 18);
            poly.addPoint(cw - 18, 9);
        } else {
            poly.addPoint(0, 0);
            poly.addPoint(0, 18);
            poly.addPoint(18, 9);
        }
        g2d.fillPolygon(poly);
        g2d.setColor(UIManager.getColor("Label.disabledForeground"));
        g2d.draw(poly);
    }
}

