/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingEditor;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.editor.mappingeditor.ContinuousMappingEditorPanel;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public abstract class AbstractContinuousMappingEditor<K extends Number, V>
extends AbstractPropertyEditor
implements ContinuousMappingEditor<K, V> {
    protected ContinuousMapping<K, V> mapping;
    protected ContinuousMappingEditorPanel<K, V> editorPanel;
    protected final EditorManager editorManager;
    protected final ServicesUtil servicesUtil;
    private final JLabel iconLabel = new JLabel();
    private boolean isEditorDialogActive = false;
    private JDialog currentDialog;

    public AbstractContinuousMappingEditor(EditorManager editorManager, final ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
        this.editorManager = editorManager;
        this.editor = new JPanel();
        ((JPanel)this.editor).setLayout(new BorderLayout());
        ((JPanel)this.editor).add((Component)this.iconLabel, "Center");
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AbstractContinuousMappingEditor.this.isEditorDialogActive) {
                    if (AbstractContinuousMappingEditor.this.currentDialog != null) {
                        AbstractContinuousMappingEditor.this.currentDialog.toFront();
                    }
                    return;
                }
                JDialog dialog = new JDialog((Window)servicesUtil.get(CySwingApplication.class).getJFrame(), Dialog.ModalityType.APPLICATION_MODAL);
                this.initComponents(dialog);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent evt) {
                        Dimension size = AbstractContinuousMappingEditor.this.editor.getSize();
                        AbstractContinuousMappingEditor.this.drawIcon(size.width, size.height, false);
                        AbstractContinuousMappingEditor.this.isEditorDialogActive = false;
                    }
                });
                dialog.setLocationRelativeTo(AbstractContinuousMappingEditor.this.editor);
                dialog.setVisible(true);
                AbstractContinuousMappingEditor.this.isEditorDialogActive = true;
                AbstractContinuousMappingEditor.this.currentDialog = dialog;
            }

            private void initComponents(JDialog dialog) {
                dialog.setTitle("Continuous Mapping Editor for " + AbstractContinuousMappingEditor.this.mapping.getVisualProperty().getDisplayName());
                dialog.setDefaultCloseOperation(2);
                dialog.getContentPane().add(AbstractContinuousMappingEditor.this.editorPanel, "Center");
                LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)dialog.getRootPane(), (Action)AbstractContinuousMappingEditor.this.editorPanel.getOkButton().getAction(), (Action)AbstractContinuousMappingEditor.this.editorPanel.getCancelButton().getAction());
                dialog.getRootPane().setDefaultButton(AbstractContinuousMappingEditor.this.editorPanel.getOkButton());
                dialog.pack();
            }
        });
    }

    @Override
    public ImageIcon drawIcon(int width, int height, boolean detail) {
        if (this.editorPanel == null) {
            return null;
        }
        ImageIcon newIcon = this.editorPanel.drawIcon(width, height, detail);
        this.iconLabel.setIcon(newIcon);
        return newIcon;
    }

    public Object getValue() {
        return this.mapping;
    }
}

