/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.PopupMenuGravityTracker;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.DropDownMenuButton;

public class OptionsButton {
    private DropDownMenuButton optionsBtn;
    private JPopupMenu mainMenu;
    private PopupMenuGravityTracker mainMenuGravityTracker;
    private final ServicesUtil servicesUtil;

    public OptionsButton(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    DropDownMenuButton getOptionsBtn() {
        if (this.optionsBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.optionsBtn = new DropDownMenuButton(this.getMainMenu(), false);
            this.optionsBtn.setToolTipText("Options...");
            this.optionsBtn.setFont(iconManager.getIconFont(12.0f));
            this.optionsBtn.setText("\uf0c9");
        }
        return this.optionsBtn;
    }

    JPopupMenu getMainMenu() {
        if (this.mainMenu == null) {
            this.mainMenu = new JPopupMenu();
        }
        return this.mainMenu;
    }

    private PopupMenuGravityTracker getMainMenuGravityTracker() {
        if (this.mainMenuGravityTracker == null) {
            this.mainMenuGravityTracker = new PopupMenuGravityTracker(this.getMainMenu());
        }
        return this.mainMenuGravityTracker;
    }

    public void addOption(JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        this.addMenuItem((GravityTracker)this.getMainMenuGravityTracker(), menuItem, gravity, insertSeparatorBefore, insertSeparatorAfter);
        if (menuItem.getAction() instanceof CyAction) {
            this.getMainMenu().addPopupMenuListener((PopupMenuListener)((CyAction)menuItem.getAction()));
        }
    }

    public void removeOption(JMenuItem menuItem) {
        this.getMainMenuGravityTracker().removeComponent((Component)menuItem);
        if (menuItem.getAction() instanceof CyAction) {
            this.getMainMenu().removePopupMenuListener((PopupMenuListener)((CyAction)menuItem.getAction()));
        }
    }

    private void addMenuItem(GravityTracker gravityTracker, JMenuItem menuItem, double gravity, boolean insertSeparatorBefore, boolean insertSeparatorAfter) {
        if (insertSeparatorBefore) {
            gravityTracker.addMenuSeparator(gravity - 1.0E-4);
        }
        gravityTracker.addMenuItem(menuItem, gravity);
        if (insertSeparatorAfter) {
            gravityTracker.addMenuSeparator(gravity + 1.0E-4);
        }
    }
}

