/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class DropDownMenuButton
extends JButton {
    private static final int TEXT_ICON_GAP = 6;
    private final Icon buttonIcon = new MenuArrowIcon();
    private JPopupMenu popupMenu;
    private final boolean showMenuArrowIcon;
    private final ActionListener defaultActionListener;

    public DropDownMenuButton() {
        this(null, true);
    }

    public DropDownMenuButton(boolean showMenuArrowIcon) {
        this(null, showMenuArrowIcon);
    }

    public DropDownMenuButton(JPopupMenu popupMenu) {
        this(popupMenu, true);
    }

    public DropDownMenuButton(JPopupMenu popupMenu, boolean showMenuArrowIcon) {
        super("");
        this.showMenuArrowIcon = showMenuArrowIcon;
        this.defaultActionListener = evt -> {
            JPopupMenu pm = this.getPopupMenu();
            if (pm != null) {
                pm.show(this, 0, this.getHeight());
                pm.requestFocusInWindow();
            }
        };
        this.setPopupMenu(popupMenu);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu != null) {
            this.addActionListener(this.defaultActionListener);
        } else {
            this.removeActionListener(this.defaultActionListener);
        }
        this.updateEnabled();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.showMenuArrowIcon) {
            d.width += this.buttonIcon.getIconWidth() + 6;
        }
        return d;
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
        this.updateEnabled();
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        this.updateEnabled();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.showMenuArrowIcon) {
            Dimension size = this.getSize();
            Insets ins = this.getInsets();
            int x = size.width - this.buttonIcon.getIconWidth() - ins.right;
            int y = ins.top + (size.height - ins.top - ins.bottom - this.buttonIcon.getIconHeight()) / 2;
            this.buttonIcon.paintIcon(this, g, x, y);
        }
    }

    private synchronized void updateEnabled() {
        ActionListener[] actionListeners = this.getActionListeners();
        this.setEnabled(actionListeners != null && actionListeners.length > 0 || this.popupMenu != null && this.popupMenu.getSubElements().length > 0);
    }

    class MenuArrowIcon
    implements Icon {
        MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(UIManager.getColor(c.isEnabled() ? "Button.foreground" : "Button.disabledForeground"));
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            int pad = 2;
            g2.translate(x, y);
            g2.fillPolygon(new int[]{pad, w - pad, w / 2}, new int[]{pad + 1, pad + 1, h - pad}, 3);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }
}

