/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.util.mapgenerator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.AbstractDiscreteMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberSeriesMappingGenerator<V extends Number>
extends AbstractDiscreteMappingGenerator<V> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public NumberSeriesMappingGenerator(Class<V> type) {
        super(type);
    }

    @Override
    public <T> Map<T, V> generateMap(Set<T> attributeSet) {
        HashMap<T, Double> valueMap = new HashMap<T, Double>();
        if (attributeSet == null || attributeSet.size() == 0) {
            return valueMap;
        }
        Double[] params = new Double[2];
        ViewUtil.invokeOnEDTAndWait(() -> this.getStartAndIncrement(params), logger);
        Double st = params[0];
        Double inc = params[1];
        if (st != null && inc != null && inc >= 0.0) {
            for (T key : attributeSet) {
                valueMap.put(key, st);
                st = st + inc;
            }
        }
        return valueMap;
    }

    private void getStartAndIncrement(Double[] params) {
        String start = JOptionPane.showInputDialog(null, "Enter start value (1st number of the series)", "0");
        String increment = JOptionPane.showInputDialog(null, "Enter increment", "1");
        if (start != null) {
            Double st = null;
            Double inc = null;
            try {
                st = Double.valueOf(start);
                inc = Double.valueOf(increment);
            }
            catch (Exception ex) {
                logger.warn("Invalid numeric value.", (Throwable)ex);
            }
            if (inc == null) {
                inc = 0.0;
            }
            params[0] = st;
            params[1] = inc;
        }
    }
}

