/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RenameVisualStyleTask
extends AbstractTask {
    public static final String TITLE = "Rename Style";
    @Tunable(description="Enter new Style name:")
    public String vsName;
    private String previousName;
    private final VisualStyle style;
    private final ServicesUtil servicesUtil;

    public RenameVisualStyleTask(VisualStyle style, ServicesUtil servicesUtil) {
        this.style = style;
        this.servicesUtil = servicesUtil;
        VisualMappingManager vmm = servicesUtil.get(VisualMappingManager.class);
        this.vsName = vmm.getCurrentVisualStyle().getTitle();
    }

    @ProvidesTitle
    public String getTitle() {
        return TITLE;
    }

    public void run(TaskMonitor monitor) throws Exception {
        this.previousName = this.style.getTitle();
        boolean renamed = this.renameVisualStyle(this.vsName);
        if (renamed) {
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new RenameVisualStyleEdit());
        }
    }

    private boolean renameVisualStyle(String name) {
        boolean renamed = false;
        if (name != null && this.style != null) {
            VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
            if (this.style.equals(vmMgr.getDefaultVisualStyle())) {
                throw new IllegalArgumentException("You cannot rename the default style.");
            }
            if (!this.style.getTitle().equals(name)) {
                this.style.setTitle(name);
                renamed = true;
                this.servicesUtil.sendNotification("VISUAL_STYLE_NAME_CHANGED", this.style);
            }
        }
        return renamed;
    }

    private class RenameVisualStyleEdit
    extends AbstractCyEdit {
        public RenameVisualStyleEdit() {
            super(RenameVisualStyleTask.this.getTitle());
        }

        public void undo() {
            VisualMappingManager vmMgr = RenameVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (RenameVisualStyleTask.this.style != null && RenameVisualStyleTask.this.previousName != null && !RenameVisualStyleTask.this.style.equals(vmMgr.getDefaultVisualStyle())) {
                RenameVisualStyleTask.this.renameVisualStyle(RenameVisualStyleTask.this.previousName);
            }
        }

        public void redo() {
            VisualMappingManager vmMgr = RenameVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (RenameVisualStyleTask.this.style != null && RenameVisualStyleTask.this.vsName != null && !RenameVisualStyleTask.this.style.equals(vmMgr.getDefaultVisualStyle())) {
                RenameVisualStyleTask.this.renameVisualStyle(RenameVisualStyleTask.this.vsName);
            }
        }
    }
}

