/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RemoveVisualMappingsTask
extends AbstractTask {
    private final Set<VisualMappingFunction<?, ?>> mappings;
    private final Set<VisualMappingFunction<?, ?>> validMappings;
    private final VisualStyle style;
    private final ServicesUtil servicesUtil;

    public RemoveVisualMappingsTask(Set<VisualMappingFunction<?, ?>> mappings, VisualStyle style, ServicesUtil servicesUtil) {
        this.mappings = mappings;
        this.style = style;
        this.servicesUtil = servicesUtil;
        this.validMappings = new HashSet();
    }

    public void run(TaskMonitor monitor) throws Exception {
        if (this.mappings != null && !this.mappings.isEmpty()) {
            ViewUtil.invokeOnEDT(() -> {
                for (VisualMappingFunction<?, ?> vm : this.mappings) {
                    if (vm == null || !vm.equals((Object)this.style.getVisualMappingFunction(vm.getVisualProperty()))) continue;
                    this.validMappings.add(vm);
                }
                if (!this.validMappings.isEmpty()) {
                    this.removeMappings();
                    UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
                    undo.postEdit((AbstractCyEdit)new RemoveVisualMappingEdit());
                }
            });
        }
    }

    private void removeMappings() {
        for (VisualMappingFunction<?, ?> vm : this.validMappings) {
            this.style.removeVisualMappingFunction(vm.getVisualProperty());
        }
    }

    private class RemoveVisualMappingEdit
    extends AbstractCyEdit {
        public RemoveVisualMappingEdit() {
            super("Remove " + RemoveVisualMappingsTask.this.validMappings.size() + " Visual Mapping" + (RemoveVisualMappingsTask.this.validMappings.size() > 1 ? "s" : ""));
        }

        public void undo() {
            for (VisualMappingFunction<?, ?> vm : RemoveVisualMappingsTask.this.validMappings) {
                RemoveVisualMappingsTask.this.style.addVisualMappingFunction(vm);
            }
        }

        public void redo() {
            RemoveVisualMappingsTask.this.removeMappings();
        }
    }
}

