/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;

public class LockedValuesVO {
    private final CyNetworkView networkView;
    private final Set<View<? extends CyIdentifiable>> views;
    private final Map<VisualProperty<?>, Object> values = new HashMap();

    public LockedValuesVO(Set<VisualProperty<?>> visualProperties) {
        this(null, null, visualProperties);
    }

    public LockedValuesVO(CyNetworkView networkView, Set<View<? extends CyIdentifiable>> views, Set<VisualProperty<?>> visualProperties) {
        this.networkView = networkView;
        this.views = views;
        for (VisualProperty<?> vp : visualProperties) {
            this.values.put(vp, null);
        }
    }

    public LockedValuesVO(Map<VisualProperty<?>, Object> values) {
        this.networkView = null;
        this.views = null;
        this.values.putAll(values);
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public Set<View<? extends CyIdentifiable>> getViews() {
        return this.views;
    }

    public Set<VisualProperty<?>> getVisualProperties() {
        return this.values.keySet();
    }

    public Map<VisualProperty<?>, Object> getValues() {
        return this.values;
    }
}

