/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.controller;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.gui.internal.model.LockedValuesVO;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.task.SetLockedValuesTask;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;
import org.puremvc.java.multicore.interfaces.INotification;
import org.puremvc.java.multicore.patterns.command.SimpleCommand;

public class SetLockedValuesCommand
extends SimpleCommand {
    private final ServicesUtil servicesUtil;

    public SetLockedValuesCommand(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public void execute(INotification notification) {
        LockedValuesVO vo = (LockedValuesVO)notification.getBody();
        Map<VisualProperty<?>, Object> values = vo.getValues();
        if (values == null) {
            return;
        }
        CyNetworkView netView = vo.getNetworkView();
        Set<View<? extends CyIdentifiable>> views = vo.getViews();
        VizMapperProxy vmProxy = (VizMapperProxy)this.getFacade().retrieveProxy("VisualStyleProxy");
        if (netView == null) {
            netView = vmProxy.getCurrentNetworkView();
        }
        if (netView != null && views == null) {
            HashSet<Class> targetDataTypes = new HashSet<Class>();
            for (VisualProperty<?> vp : values.keySet()) {
                targetDataTypes.add(vp.getTargetDataType());
            }
            views = new HashSet<View<? extends CyIdentifiable>>();
            if (targetDataTypes.contains(CyNode.class)) {
                views.addAll(vmProxy.getSelectedNodeViews(netView));
            }
            if (targetDataTypes.contains(CyEdge.class)) {
                views.addAll(vmProxy.getSelectedEdgeViews(netView));
            }
            if (targetDataTypes.contains(CyNetwork.class)) {
                views.add((View<? extends CyIdentifiable>)netView);
            }
        }
        if (views != null) {
            TaskIterator iterator = new TaskIterator(new Task[]{new SetLockedValuesTask(values, views, netView, this.servicesUtil)});
            DialogTaskManager taskManager = this.servicesUtil.get(DialogTaskManager.class);
            taskManager.execute(iterator);
        }
    }
}

