/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.action;

import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.action.AbstractVizMapperAction;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMainPanel;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class RemoveSelectedDiscreteValuesAction
extends AbstractVizMapperAction {
    public static final String NAME = "Remove Selected Discrete Mapping Values";
    private static final long serialVersionUID = 5111684472796917297L;
    private final Map<DiscreteMapping<?, ?>, Map<Object, Object>> previousMappingValues = new HashMap();

    public RemoveSelectedDiscreteValuesAction(ServicesUtil servicesUtil) {
        super(NAME, servicesUtil);
    }

    public void actionPerformed(ActionEvent e) {
        VizMapperMainPanel vizMapperMainPanel = this.getVizMapperMainPanel();
        if (vizMapperMainPanel == null) {
            return;
        }
        VisualPropertySheet vpSheet = vizMapperMainPanel.getSelectedVisualPropertySheet();
        if (vpSheet == null) {
            return;
        }
        for (VisualPropertySheetItem<?> vpSheetItem : vpSheet.getSelectedItems()) {
            VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
            PropertySheetTable table = vpSheetItem.getPropSheetPnl().getTable();
            int[] selected = table.getSelectedRows();
            if (selected == null || selected.length == 0 || !(model.getVisualMappingFunction() instanceof DiscreteMapping)) continue;
            DiscreteMapping dm = (DiscreteMapping)model.getVisualMappingFunction();
            HashMap newValues = new HashMap();
            HashMap previousValues = new HashMap();
            for (int i = 0; i < selected.length; ++i) {
                VizMapperProperty prop;
                PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)table.getValueAt(selected[i], 0);
                if (item == null || !(item.getProperty() instanceof VizMapperProperty) || (prop = (VizMapperProperty)item.getProperty()).getCellType() != CellType.DISCRETE) continue;
                if (prop.getValue() != null) {
                    previousValues.put(prop.getKey(), prop.getValue());
                }
                newValues.put(prop.getKey(), null);
            }
            if (!previousValues.isEmpty()) {
                this.previousMappingValues.put(dm, previousValues);
            }
            dm.putAll(newValues);
        }
        if (!this.previousMappingValues.isEmpty()) {
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new RemoveSelectedDiscreteValuesEdit());
        }
    }

    public void updateEnableState() {
        boolean enabled = false;
        VizMapperMainPanel vizMapperMainPanel = this.getVizMapperMainPanel();
        VisualPropertySheet vpSheet = null;
        if (vizMapperMainPanel != null) {
            vpSheet = vizMapperMainPanel.getSelectedVisualPropertySheet();
        }
        if (vpSheet != null) {
            block0: for (VisualPropertySheetItem<?> vpSheetItem : vpSheet.getSelectedItems()) {
                VisualPropertySheetItemModel<?> model = vpSheetItem.getModel();
                PropertySheetTable table = vpSheetItem.getPropSheetPnl().getTable();
                int[] selected = table.getSelectedRows();
                if (selected == null || !(model.getVisualMappingFunction() instanceof DiscreteMapping)) continue;
                for (int i = 0; i < selected.length; ++i) {
                    VizMapperProperty prop;
                    PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)table.getValueAt(selected[i], 0);
                    if (item == null || !(item.getProperty() instanceof VizMapperProperty) || (prop = (VizMapperProperty)item.getProperty()).getCellType() != CellType.DISCRETE || prop.getValue() == null) continue;
                    enabled = true;
                    continue block0;
                }
            }
        }
        this.setEnabled(enabled);
    }

    private class RemoveSelectedDiscreteValuesEdit
    extends AbstractCyEdit {
        public RemoveSelectedDiscreteValuesEdit() {
            super(RemoveSelectedDiscreteValuesAction.NAME);
        }

        public void undo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, Object>> entry : RemoveSelectedDiscreteValuesAction.this.previousMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                dm.putAll(entry.getValue());
            }
        }

        public void redo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, Object>> entry : RemoveSelectedDiscreteValuesAction.this.previousMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                HashMap newValues = new HashMap();
                for (Map.Entry<Object, Object> originalEntry : entry.getValue().entrySet()) {
                    newValues.put(originalEntry.getKey(), null);
                }
                if (newValues.isEmpty()) continue;
                dm.putAll(newValues);
            }
        }
    }
}

